/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;

public class PropertiesConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(PropertiesConfigurationBuilder.class);
    public static final String IBEANS_PROPERTIES_LOCATION = "ibeans.properties.location";
    public static final String IBEANS_PROPERTIES = "META-INF/ibeans-app.properties";
    private boolean loadFromUserHome = false;

    public boolean isLoadFromUserHome() {
        return this.loadFromUserHome;
    }

    public void setLoadFromUserHome(boolean loadFromUserHome) {
        this.loadFromUserHome = loadFromUserHome;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        File f;
        Properties props = new Properties();
        URL url = ClassUtils.getResource((String)IBEANS_PROPERTIES, ((Object)((Object)this)).getClass());
        if (url != null) {
            InputStream in = null;
            try {
                in = url.openStream();
                props.load(in);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            this.logger.info((Object)"No application properties found at: META-INF/ibeans-app.properties");
        }
        String propsLocation = System.getProperty(IBEANS_PROPERTIES_LOCATION, null);
        if (propsLocation != null) {
            f = new File(propsLocation);
            this.loadProperties(f, props);
        }
        if (this.isLoadFromUserHome()) {
            f = new File(System.getProperty("user.home") + File.separator + ".ibeans.properties");
            this.loadProperties(f, props);
        }
        if (props.size() > 0) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                muleContext.getRegistry().registerObject(entry.getKey().toString(), entry.getValue());
            }
        } else {
            this.logger.info((Object)"No properties found to load by the PropertiesConfigurationBuilder");
        }
    }

    protected void loadProperties(File file, Properties props) {
        this.logger.info((Object)("Attempting to load iBeans properties from: " + file.getAbsolutePath()));
        if (file.exists()) {
            this.logger.info((Object)("iBeans properties found properties in: " + file.getAbsolutePath()));
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                props.load(in);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(in);
            }
        }
    }
}

