/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.mule.api.MessageProcessorAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.meta.ChannelType;
import org.mule.api.annotations.meta.Router;
import org.mule.api.annotations.meta.RouterType;
import org.mule.api.component.Component;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.AnnotationsParserFactory;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.PoolingProfile;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.expression.ExpressionConfig;
import org.mule.ibeans.internal.IBeansEntrypointResolverSet;
import org.mule.ibeans.internal.IBeansObjectFactory;
import org.mule.ibeans.internal.IBeansPrototypeObjectFactory;
import org.mule.ibeans.internal.IBeansSingletonObjectFactory;
import org.mule.model.seda.SedaService;
import org.mule.module.annotationx.api.Reply;
import org.mule.module.annotationx.config.AnnotatedServiceBuilder;
import org.mule.module.annotationx.config.ObjectScope;
import org.mule.routing.outbound.ExpressionMessageSplitter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.transport.AbstractConnector;
import org.mule.transport.quartz.jobs.EndpointPollingJobConfig;
import org.mule.util.annotation.AnnotationMetaData;

public class MuleiBeansAnnotatedServiceBuilder
extends AnnotatedServiceBuilder {
    public MuleiBeansAnnotatedServiceBuilder(MuleContext context) throws MuleException {
        super(context);
        this.parserFactory = (AnnotationsParserFactory)context.getRegistry().lookupObject(AnnotationsParserFactory.class);
        assert (this.parserFactory != null);
    }

    protected ObjectFactory createObjectFactory(Object object) {
        IBeansObjectFactory factory;
        if (object.getClass().isAnnotationPresent(org.mule.module.annotationx.api.Service.class)) {
            org.mule.module.annotationx.api.Service service = object.getClass().getAnnotation(org.mule.module.annotationx.api.Service.class);
            if (service.scope().equals((Object)ObjectScope.SINGLETON) || service.scope().equals((Object)ObjectScope.SINGLETON_THREADSAFE)) {
                return new IBeansSingletonObjectFactory(object);
            }
            factory = new IBeansPrototypeObjectFactory(object);
        } else {
            factory = object.getClass().isAnnotationPresent(Singleton.class) ? new IBeansSingletonObjectFactory(object) : new IBeansPrototypeObjectFactory(object);
        }
        return factory;
    }

    protected synchronized Service create(ObjectFactory componentFactory) throws InitialisationException {
        SedaService serviceDescriptor = new SedaService(this.context);
        serviceDescriptor.setModel(this.getModel());
        if (componentFactory instanceof ServiceAware) {
            ((ServiceAware)componentFactory).setService((Service)serviceDescriptor);
        }
        componentFactory.initialise();
        ServiceConfig config = componentFactory.getObjectClass().isAnnotationPresent(org.mule.module.annotationx.api.Service.class) ? new ServiceConfig(componentFactory.getObjectClass().getAnnotation(org.mule.module.annotationx.api.Service.class)) : new ServiceConfig(ObjectScope.POOLED, 8, null);
        if (config.getName() == null) {
            config.generateName(componentFactory.getObjectClass());
        }
        serviceDescriptor.setName(config.getName());
        if (config.getScope() == ObjectScope.POOLED) {
            PoolingProfile pp = new PoolingProfile();
            pp.setMaxActive(config.getMaxThreads());
            pp.setMaxIdle(config.getMaxThreads());
            PooledJavaComponent comp = new PooledJavaComponent(componentFactory, pp);
            serviceDescriptor.setComponent((Component)comp);
            comp.setEntryPointResolverSet((EntryPointResolverSet)new IBeansEntrypointResolverSet());
        } else {
            DefaultJavaComponent component = new DefaultJavaComponent(componentFactory);
            serviceDescriptor.setComponent((Component)component);
            if (config.getScope() == ObjectScope.SINGLETON_THREADSAFE) {
                component.setEntryPointResolverSet((EntryPointResolverSet)new IBeansEntrypointResolverSet(true));
            } else {
                component.setEntryPointResolverSet((EntryPointResolverSet)new IBeansEntrypointResolverSet());
            }
        }
        ChainedThreadingProfile tp = new ChainedThreadingProfile(this.context.getDefaultServiceThreadingProfile(), true);
        tp.setMaxThreadsActive(config.getMaxThreads());
        tp.setMaxThreadsIdle(config.getMaxThreads());
        tp.setPoolExhaustedAction(0);
        serviceDescriptor.setThreadingProfile((ThreadingProfile)tp);
        serviceDescriptor.setModel(this.getModel());
        return serviceDescriptor;
    }

    public Service createService(Object object) throws MuleException {
        Service serviceDescriptor = this.create(this.createObjectFactory(object));
        Class<?> componentClass = object.getClass();
        this.processInboundRouters(componentClass, serviceDescriptor);
        for (int i = 0; i < componentClass.getMethods().length; ++i) {
            Method method = componentClass.getMethods()[i];
            this.processInbound(serviceDescriptor, componentClass, method);
            this.processReply(serviceDescriptor, componentClass, method);
            this.processOutbound(serviceDescriptor, componentClass, method);
        }
        return serviceDescriptor;
    }

    protected void processInbound(Service service, Class clazz, Method method) throws MuleException {
        HashMap<String, InboundEndpoint> endpoints = new HashMap<String, InboundEndpoint>();
        for (int i = 0; i < method.getAnnotations().length; ++i) {
            Annotation annotation = method.getAnnotations()[i];
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(new AnnotationMetaData(clazz, (Member)method, ElementType.METHOD, annotation), ChannelType.Inbound);
            if (inboundEndpoint == null) continue;
            inboundEndpoint.getProperties().put("method", method.getName());
            endpoints.put(inboundEndpoint.getEndpointURI().getScheme(), inboundEndpoint);
        }
        if (endpoints.containsKey("quartz") && endpoints.size() == 2) {
            InboundEndpoint schedule = null;
            InboundEndpoint poll = null;
            for (Map.Entry endpointEntry : endpoints.entrySet()) {
                if (((String)endpointEntry.getKey()).equals("quartz")) {
                    schedule = (InboundEndpoint)endpointEntry.getValue();
                    continue;
                }
                poll = (InboundEndpoint)endpointEntry.getValue();
            }
            int threads = ((AbstractConnector)poll.getConnector()).getReceiverThreadingProfile().getMaxThreadsActive();
            EndpointPollingJobConfig jobConfig = new EndpointPollingJobConfig();
            jobConfig.setStateful(threads == 1);
            this.context.getRegistry().registerEndpointBuilder(poll.getName(), (EndpointBuilder)new EndpointURIEndpointBuilder((ImmutableEndpoint)poll));
            jobConfig.setEndpointRef(poll.getName());
            schedule.getProperties().put("jobConfig", jobConfig);
            ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)schedule);
            for (MessageProcessor processor : poll.getMessageProcessors()) {
                ((ServiceCompositeMessageSource)service.getMessageSource()).addMessageProcessor(processor);
            }
        } else {
            for (InboundEndpoint endpoint : endpoints.values()) {
                ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
            }
        }
    }

    protected void processReply(Service service, Class clazz, Method method) throws MuleException {
        InboundEndpoint inboundEndpoint;
        Reply annotation = method.getAnnotation(Reply.class);
        if (annotation != null && (inboundEndpoint = this.tryInboundEndpointAnnotation(new AnnotationMetaData(clazz, (Member)method, ElementType.METHOD, (Annotation)annotation), ChannelType.Reply)) != null) {
            service.getAsyncReplyMessageSource().addSource((MessageSource)inboundEndpoint);
            this.processReplyRouters(service, clazz, method);
        }
    }

    protected void processReplyRouters(Service service, Class clazz, Method method) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(MessageProcessorAnnotationParser.class);
        block0: for (int i = 0; i < method.getAnnotations().length; ++i) {
            Annotation annotation = method.getAnnotations()[i];
            Router routerAnnotation = annotation.annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.ReplyTo) continue;
            for (MessageProcessorAnnotationParser parser : routerParsers) {
                if (!parser.supports(annotation, clazz, (Member)method)) continue;
                MessageProcessor router = parser.parseMessageProcessor(annotation);
                if (router instanceof MuleContextAware) {
                    ((MuleContextAware)router).setMuleContext(this.context);
                }
                service.getAsyncReplyMessageSource().addMessageProcessor(router);
                continue block0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processOutbound(Service service, Class clazz, Method method) throws MuleException {
        OutboundRouter router = this.processOutboundRouter(clazz, method);
        Reply replyEp = method.getAnnotation(Reply.class);
        if (replyEp != null) {
            router.setReplyTo(replyEp.uri());
        }
        boolean outboundFound = false;
        for (int i = 0; i < method.getAnnotations().length; ++i) {
            Annotation annotation = method.getAnnotations()[i];
            OutboundEndpoint outboundEndpoint = this.tryOutboundEndpointAnnotation(new AnnotationMetaData(clazz, (Member)method, ElementType.METHOD, annotation), ChannelType.Outbound);
            if (outboundEndpoint == null) continue;
            String splitExpression = (String)outboundEndpoint.getProperties().remove("split-expression");
            if (splitExpression != null) {
                if (splitExpression.equals("default")) {
                    if (!List.class.isAssignableFrom(method.getReturnType())) throw new IllegalArgumentException("A split expression has been set on a @Send annotation to 'default' which means that the retern class from " + method.toString() + " needs to be assignable from java.util.List");
                    router = new ListMessageSplitter();
                } else {
                    ExpressionConfig config = new ExpressionConfig();
                    config.parse(splitExpression);
                    config.validate(this.context.getExpressionManager());
                    router = new ExpressionMessageSplitter(config);
                }
            }
            outboundEndpoint.getProperties().put("ibeans.endpoint.method", method.toString());
            router.addRoute((MessageProcessor)outboundEndpoint);
            outboundFound = true;
        }
        if (!outboundFound) return;
        router.setMuleContext(this.context);
        router.initialise();
        ((OutboundRouterCollection)service.getOutboundMessageProcessor()).addRoute((MatchableMessageProcessor)router);
    }

    protected OutboundRouter processOutboundRouter(Class clazz, Method method) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(MessageProcessorAnnotationParser.class);
        FilteringOutboundRouter router = null;
        block0: for (int i = 0; i < method.getAnnotations().length; ++i) {
            Annotation annotation = method.getAnnotations()[i];
            Router routerAnnotation = annotation.annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Outbound) continue;
            if (router != null) {
                throw new IllegalStateException("You can onnly configure one outbound router on a service");
            }
            for (MessageProcessorAnnotationParser parser : routerParsers) {
                if (!parser.supports(annotation, clazz, (Member)method)) continue;
                router = (OutboundRouter)parser.parseMessageProcessor(annotation);
                continue block0;
            }
        }
        if (router == null) {
            router = new FilteringOutboundRouter();
        }
        router.setMuleContext(this.context);
        router.initialise();
        return router;
    }

    private class ServiceConfig {
        private ObjectScope scope;
        private int maxThreads;
        private String name;

        private ServiceConfig(org.mule.module.annotationx.api.Service config) {
            this.scope = config.scope();
            this.maxThreads = config.maxAsyncThreads();
            this.name = config.name().length() == 0 ? null : config.name();
        }

        private ServiceConfig(ObjectScope scope, int maxThreads, String name) {
            this.scope = scope;
            this.maxThreads = maxThreads;
            this.name = name == null || name.length() == 0 ? null : name;
        }

        public ObjectScope getScope() {
            return this.scope;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public String getName() {
            return this.name;
        }

        public void generateName(Class serviceClass) {
            this.name = serviceClass.getSimpleName() + ".service";
        }
    }
}

