/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.config.MuleConfiguration;

public class IBeansInfo {
    protected static final transient Log logger = LogFactory.getLog(IBeansInfo.class);
    private static Manifest manifest;

    public static String getProductVersion() {
        return IBeansInfo.getManifestProperty("Implementation-Version");
    }

    public static String getVendorName() {
        return IBeansInfo.getManifestProperty("Implementation-Vendor");
    }

    public static String getVendorUrl() {
        return IBeansInfo.getManifestProperty("Implementation-Vendor-Url");
    }

    public static String getProductUrl() {
        return IBeansInfo.getManifestProperty("Implementation-Url");
    }

    public static String getProductName() {
        return IBeansInfo.getManifestProperty("Implementation-Title");
    }

    public static String getProductMoreInfo() {
        return IBeansInfo.getManifestProperty("More-Info");
    }

    public static String getProductSupport() {
        return IBeansInfo.getManifestProperty("Support");
    }

    public static String getProductLicenseInfo() {
        return IBeansInfo.getManifestProperty("License-Title");
    }

    public static String getProductDescription() {
        return IBeansInfo.getManifestProperty("Product-Description");
    }

    public static String getBuildNumber() {
        return IBeansInfo.getManifestProperty("Build-Revision");
    }

    public static String getBuildDate() {
        return IBeansInfo.getManifestProperty("Build-Date");
    }

    public static String getDevListEmail() {
        return IBeansInfo.getManifestProperty("Dev-List-Email");
    }

    public static Manifest getManifest() {
        if (manifest == null) {
            manifest = new Manifest();
            InputStream is = null;
            try {
                URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        try {
                            Enumeration<URL> e = MuleConfiguration.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                            while (e.hasMoreElements()) {
                                URL url = e.nextElement();
                                if (url.toExternalForm().indexOf("ibeans-core") <= -1 || url.toExternalForm().indexOf("tests.jar") >= 0) continue;
                                return url;
                            }
                        }
                        catch (IOException e1) {
                            logger.warn((Object)("Failure reading manifest: " + e1.getMessage()), (Throwable)e1);
                        }
                        return null;
                    }
                });
                if (url != null) {
                    is = url.openStream();
                }
                if (is != null) {
                    manifest.read(is);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to read manifest Info, Manifest information will not display correctly: " + e.getMessage()));
            }
        }
        return manifest;
    }

    protected static String getManifestProperty(String name) {
        return IBeansInfo.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }
}

