/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal.proxies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.service.Service;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.NullPayload;

public class IBeanServiceInvocationHandler
implements InvocationHandler {
    private Service service;
    private Object theBean;

    public IBeanServiceInvocationHandler(Service service, Object bean) {
        this.service = service;
        this.theBean = bean;
    }

    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        if (method.getAnnotations().length == 0) {
            return method.invoke(this.theBean, args);
        }
        MuleMessage message = this.createMuleMessage(args);
        message.setProperty("method", (Object)method.getName(), PropertyScope.INVOCATION);
        MuleEvent currentEvent = RequestContext.getEvent();
        MuleEvent reply = this.service.getOutboundMessageProcessor().process((MuleEvent)new DefaultMuleEvent(message, currentEvent));
        if (reply.getMessage().getExceptionPayload() != null) {
            throw this.findDeclaredMethodException(method, reply.getMessage().getExceptionPayload().getException());
        }
        return this.determineReply(reply.getMessage(), method);
    }

    private MuleMessage createMuleMessage(Object[] args) {
        if (args == null) {
            return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.service.getMuleContext());
        }
        if (args.length == 1) {
            return new DefaultMuleMessage(args[0], this.service.getMuleContext());
        }
        return new DefaultMuleMessage((Object)args, this.service.getMuleContext());
    }

    private Throwable findDeclaredMethodException(Method method, Throwable throwable) throws Throwable {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Class<?>[] exceptions = method.getExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                if (!cause.getClass().equals(exceptions[i])) continue;
                return cause;
            }
        }
        return throwable;
    }

    private Object determineReply(MuleMessage reply, Method bindingMethod) {
        if (MuleMessage.class.isAssignableFrom(bindingMethod.getReturnType())) {
            return reply;
        }
        return reply.getPayload();
    }
}

