/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal.proxies;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.service.Service;
import org.mule.api.transport.PropertyScope;
import org.mule.module.annotationx.api.Send;
import org.mule.transport.NullPayload;

public class IBeanServiceMethodInterceptor
implements MethodInterceptor {
    private Service service;

    public IBeanServiceMethodInterceptor(Service service) {
        this.service = service;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Method realMethod = obj.getClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes());
        Object result = proxy.invokeSuper(obj, args);
        if (!realMethod.isAnnotationPresent(Send.class)) {
            return result;
        }
        MuleMessage message = this.createMuleMessage(result);
        message.setProperty("method", (Object)method.getName(), PropertyScope.INVOCATION);
        MuleEvent currentEvent = RequestContext.getEvent();
        MuleEvent reply = this.service.getOutboundMessageProcessor().process((MuleEvent)new DefaultMuleEvent(message, currentEvent));
        if (reply.getMessage().getExceptionPayload() != null) {
            throw this.findDeclaredMethodException(method, reply.getMessage().getExceptionPayload().getException());
        }
        return this.determineReply(reply.getMessage(), method);
    }

    private MuleMessage createMuleMessage(Object arg) {
        if (arg == null) {
            return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.service.getMuleContext());
        }
        return new DefaultMuleMessage(arg, this.service.getMuleContext());
    }

    private Throwable findDeclaredMethodException(Method method, Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Class<?>[] exceptions = method.getExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                if (!cause.getClass().equals(exceptions[i])) continue;
                return cause;
            }
        }
        return throwable;
    }

    private Object determineReply(MuleMessage reply, Method bindingMethod) {
        if (MuleMessage.class.isAssignableFrom(bindingMethod.getReturnType())) {
            return reply;
        }
        return reply.getPayload();
    }
}

