/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MuleContext;
import org.mule.api.registry.RegistrationException;
import org.mule.ibeans.web.IBeansServletContextListener;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.util.IOUtils;

public class IBeansServlet
extends MuleReceiverServlet {
    public static final String CONFIG_BUILDER_PARAM = "config.builder";
    public static final String STATIC_FILE_TYPES_PARAM = "static.file.types";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String DEFAULT_STATIC_FILE_TYPES = "*.js";
    private WildcardFilter staticFileFilter;
    private IBeansServletContextListener listener;

    protected MuleContext setupMuleContext() throws ServletException {
        MuleContext muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        if (muleContext == null) {
            String configBuilder = this.getConfigBuilderName();
            this.listener = this.createIBeansContextListener(configBuilder);
            this.listener.initialize(this.getServletContext());
        }
        if ((muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context")) == null) {
            throw new ServletException("The MuleContext was not created successfully.  Check previous log errors for the cause");
        }
        return muleContext;
    }

    protected IBeansServletContextListener createIBeansContextListener(String configBuilder) {
        return new IBeansServletContextListener(configBuilder);
    }

    protected String getConfigBuilderName() {
        String configBuilder = this.getServletConfig().getInitParameter(CONFIG_BUILDER_PARAM);
        if (configBuilder == null) {
            configBuilder = "ibeans";
        }
        return configBuilder;
    }

    protected void doInit() throws ServletException {
        super.doInit();
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = this.getServletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            params.put(paramName, this.getServletConfig().getInitParameter(paramName));
        }
        params.remove(CONFIG_BUILDER_PARAM);
        String staticfiles = (String)params.remove(STATIC_FILE_TYPES_PARAM);
        if (staticfiles == null) {
            staticfiles = DEFAULT_STATIC_FILE_TYPES;
        }
        this.staticFileFilter = new WildcardFilter(staticfiles);
        try {
            this.muleContext.getRegistry().registerObjects(params);
        }
        catch (RegistrationException e1) {
            throw new ServletException("Failed to add config params to the iBeans registry", (Throwable)e1);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("GET".equalsIgnoreCase(request.getMethod()) && this.staticFileFilter.accept((Object)request.getPathInfo())) {
            this.loadJarResource(request.getPathInfo(), response);
            return;
        }
        super.service(request, response);
    }

    public void destroy() {
        super.destroy();
        if (this.listener != null) {
            this.listener.destroy();
        }
    }

    protected void loadJarResource(String file, HttpServletResponse resp) throws ServletException {
        InputStream in = null;
        try {
            String temp;
            String localFile = file;
            if (localFile.startsWith("/")) {
                localFile = localFile.substring(1);
            }
            if ((in = IOUtils.getResourceAsStream((String)localFile, ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false)) == null) {
                resp.setStatus(404);
                resp.getWriter().write("Unable to find file: " + file);
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = DEFAULT_MIME_TYPE;
            if (this.getServletContext() != null && (temp = this.getServletContext().getMimeType(file)) != null) {
                mimetype = temp;
            }
            resp.setContentType(mimetype);
            resp.setContentLength(buffer.length);
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + file + "\"");
            resp.getOutputStream().write(buffer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                resp.getOutputStream().flush();
            }
            catch (IOException e) {
                this.log(e.getMessage(), e);
            }
        }
    }
}

