/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.ibeans.IBeansContext;
import org.mule.ibeans.config.PropertiesConfigurationBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextFactory;
import org.mule.module.ibeans.config.IBeanHolderConfigurationBuilder;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeansServletContextListener
implements ServletContextListener {
    public static final String DEFAULT_CONFIG_BUILDER = "ibeans";
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String PROPERTIES = "config-builders.properties";
    private String configBuilder = "ibeans";
    private MuleContext muleContext;

    public IBeansServletContextListener() {
    }

    public IBeansServletContextListener(String configBuilder) {
        this.configBuilder = configBuilder;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.initialize(event.getServletContext());
    }

    public void initialize(ServletContext context) {
        try {
            this.muleContext = this.createMuleContext(context);
            context.setAttribute("mule.context", (Object)this.muleContext);
            IBeansContext iBeansContext = (IBeansContext)this.muleContext.getRegistry().lookupObject(IBeansContext.class);
            context.setAttribute("mule.ibeans.context", (Object)iBeansContext);
            this.muleContext.start();
        }
        catch (MuleException ex) {
            context.log(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            context.log(error.getMessage(), (Throwable)error);
            error.printStackTrace();
            throw error;
        }
    }

    protected MuleContext createMuleContext(ServletContext context) throws ConfigurationException, InitialisationException {
        try {
            Properties builderMappings = this.getBuilderMappings();
            if (!builderMappings.containsKey(this.configBuilder)) {
                throw new ConfigurationException(CoreMessages.createStaticMessage((String)("Unknown builder name: " + this.configBuilder)));
            }
            this.configBuilder = builderMappings.getProperty(this.configBuilder);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        String serverId = StringUtils.defaultIfEmpty((String)context.getInitParameter("mule.serverId"), null);
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        this.addConfigurationBuilders(builders);
        IBeansMuleContextFactory muleContextFactory = new IBeansMuleContextFactory();
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        if (serverId != null) {
            muleConfiguration.setId(serverId);
        }
        IBeansMuleContextBuilder muleContextBuilder = new IBeansMuleContextBuilder();
        muleContextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
        return muleContextFactory.createMuleContext(builders, (MuleContextBuilder)muleContextBuilder);
    }

    protected void addConfigurationBuilders(List<ConfigurationBuilder> builders) throws ConfigurationException {
        builders.add((ConfigurationBuilder)new PropertiesConfigurationBuilder());
        builders.add((ConfigurationBuilder)new DefaultsConfigurationBuilder());
        try {
            ConfigurationBuilder builder = (ConfigurationBuilder)ClassUtils.instanciateClass((String)this.configBuilder, (Object[])ClassUtils.NO_ARGS);
            builders.add(builder);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        builders.add((ConfigurationBuilder)new IBeanHolderConfigurationBuilder());
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.destroy();
    }

    protected void destroy() {
        if (!(this.muleContext == null || this.muleContext.isDisposing() && this.muleContext.isDisposed())) {
            this.muleContext.dispose();
        }
    }

    MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected Properties getBuilderMappings() throws IOException {
        Properties p = new Properties();
        Enumeration e = ClassUtils.getResources((String)"META-INF/services/org/mule/config/config-builders.properties", this.getClass());
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            p.load(url.openStream());
        }
        return p;
    }
}

