/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.ibeanscentral;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.mule.api.annotations.Transformer;
import org.mule.ibeans.ibeanscentral.IBeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeanCentralTransformers {
    public static final QName METADATA_QNAME = new QName("http://galaxy.mule.org/2.0", "metadata");

    @Transformer(sourceTypes={InputStream.class, String.class})
    public List<IBeanInfo> feedXmlToIBeanInfoList(Feed feed) {
        ArrayList<IBeanInfo> results = new ArrayList<IBeanInfo>(feed.getEntries().size());
        for (Entry entry : feed.getEntries()) {
            IBeanInfo info = this.entryToIBeanInfo(entry);
            results.add(info);
        }
        return results;
    }

    @Transformer(sourceTypes={InputStream.class, String.class})
    public IBeanInfo feedXmlToIBeanInfo(Feed feed) {
        if (feed.getEntries().size() == 0) {
            return null;
        }
        Entry entry = (Entry)feed.getEntries().get(0);
        return this.entryToIBeanInfo(entry);
    }

    public IBeanInfo entryToIBeanInfo(Entry entry) {
        IBeanInfo info = new IBeanInfo();
        ExtensibleElement metadata = (ExtensibleElement)entry.getExtension(METADATA_QNAME);
        Properties props = new Properties();
        for (Element p : metadata.getElements()) {
            if (p.getAttributeValue("value") == null) continue;
            props.setProperty(p.getAttributeValue("name"), p.getAttributeValue("value"));
        }
        String specTitle = props.getProperty("jar.manifest.Specification-Title");
        info.setFileName(specTitle);
        info.setShortName(specTitle.substring(0, specTitle.indexOf("-")));
        info.setName(props.getProperty("jar.manifest.Implementation-Title"));
        info.setVersion(props.getProperty("jar.manifest.Implementation-Version"));
        info.setDescription(props.getProperty("jar.manifest.Product-Description"));
        info.setDownloadUri(entry.getContentSrc().toString());
        info.setAuthorName(props.getProperty("jar.manifest.Implementation-Vendor"));
        info.setAuthorUrl(props.getProperty("jar.manifest.Implementation-Vendor-Url"));
        info.setLicenseName(props.getProperty("jar.manifest.License-Title"));
        info.setLicenseUrl(props.getProperty("jar.manifest.License-Url"));
        info.setUrl(props.getProperty("jar.manifest.Implementation-Url"));
        return info;
    }
}

