/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jmh;

import java.io.FileNotFoundException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.jmh.report.influx.InfluxConnectionProperties;
import org.mule.jmh.report.influx.InfluxReporter;

@Mojo(name="generate-report", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
@Execute(goal="generate-report")
public class InfluxReportGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}/reports/jmh/results.json")
    private String reportPath;
    @Parameter(defaultValue="${project.artifactId}_db")
    private String dbName;
    @Parameter(defaultValue="http://localhost:8086")
    private String dbUrl;
    @Parameter
    private String dbUserName;
    @Parameter
    private String dbUserPassowrd;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new InfluxReporter().createReport(this.reportPath, this.dbName, new InfluxConnectionProperties(this.dbUrl, this.dbUserName, this.dbUserPassowrd));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Report : " + this.reportPath + " was not found.", (Exception)e);
        }
    }
}

