/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jmh.report.influx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.mule.jmh.report.influx.InfluxConnectionProperties;
import org.mule.jmh.report.influx.JMHResult;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.module.json.reader.JsonReader;
import org.mule.weave.v2.module.reader.SourceProvider$;
import org.mule.weave.v2.module.reader.SourceReader$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.exception.LocatableException;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.WeaveCompiler;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import scala.Tuple2;
import scala.collection.immutable.Map;

public class InfluxReporter {
    public void createReport(String jsonReport, String dbName, InfluxConnectionProperties connectionProperties) throws FileNotFoundException {
        InfluxDB influxDB = InfluxDBFactory.connect((String)connectionProperties.getUrl(), (String)connectionProperties.getUserName(), (String)connectionProperties.getPassword());
        List databases = influxDB.describeDatabases();
        if (!databases.contains(dbName)) {
            influxDB.createDatabase(dbName);
        }
        BatchPoints batchPoints = BatchPoints.database((String)dbName).tag("async", "true").retentionPolicy("autogen").consistency(InfluxDB.ConsistencyLevel.ALL).build();
        WeaveResource weaveFile = WeaveResourceFactory.fromUrl((URL)this.getClass().getClassLoader().getResource("report_processor.dwl"));
        PhaseResult compile = WeaveCompiler.compile((WeaveResource)weaveFile, (ParsingContext)ParsingContextFactory.createParsingContext((NameIdentifier)NameIdentifier.anonymous()));
        ExecutableWeave executable = ((CompilationResult)compile.getResult()).executable();
        JsonReader jsonReader = new JsonReader(SourceReader$.MODULE$.apply(SourceProvider$.MODULE$.apply(new File(jsonReport), Charset.forName("UTF-8"))), EvaluationContext$.MODULE$.apply());
        Map payload = executable.write$default$2().$plus(Tuple2.apply((Object)"in0", (Object)jsonReader));
        try {
            String gitHash = this.calculateGitHash();
            String commitMessage = this.calculateGitCommitMessage();
            Tuple2 result = executable.write(executable.write$default$1(), payload, executable.write$default$3(), EvaluationContext$.MODULE$.apply());
            List results = (List)result._1();
            for (JMHResult jmhResult : results) {
                Point.Builder builder = Point.measurement((String)jmhResult.getName()).time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                Set<Map.Entry<String, Object>> fields = jmhResult.getMeassures().entrySet();
                for (Map.Entry<String, Object> field : fields) {
                    if (field.getValue() instanceof Double) {
                        builder.addField(field.getKey(), (Number)((Double)field.getValue()));
                        continue;
                    }
                    if (field.getValue() instanceof Integer) {
                        builder.addField(field.getKey(), ((Integer)field.getValue()).doubleValue());
                        continue;
                    }
                    if (field.getValue() instanceof Boolean) {
                        builder.addField(field.getKey(), ((Boolean)field.getValue()).booleanValue());
                        continue;
                    }
                    builder.addField(field.getKey(), field.getValue().toString());
                }
                builder.addField("git", gitHash);
                builder.addField("commit.msg", commitMessage);
                batchPoints.point(builder.build());
                Thread.sleep(2L);
            }
            influxDB.write(batchPoints);
        }
        catch (Exception e) {
            if (e instanceof LocatableException) {
                System.err.println(((LocatableException)e).formatErrorLine());
            }
            throw new RuntimeException(e);
        }
    }

    private String readLines(BufferedReader reader) throws IOException, InterruptedException {
        String line;
        StringBuilder stringBuffer = new StringBuilder("");
        while ((line = reader.readLine()) != null) {
            stringBuffer.append(line);
        }
        return stringBuffer.toString();
    }

    private String exec(String cmd) throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(cmd);
        exec.waitFor();
        InputStream output = exec.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(output));
        return this.readLines(reader);
    }

    private String calculateGitHash() throws IOException, InterruptedException {
        return this.exec("git rev-parse HEAD");
    }

    private String calculateGitCommitMessage() throws IOException, InterruptedException {
        return this.exec("echo \"`git log -1`\"");
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length == 5) {
            String reportPath = args[0];
            String dataBaseName = args[1];
            String url = args[2];
            String username = args[3];
            String password = args[4];
            new InfluxReporter().createReport(reportPath, dataBaseName, new InfluxConnectionProperties(url, username, password));
            System.out.print("Result inserted successfully.");
        } else {
            System.err.println("Expecting 5 parameters <reportPath> <dataBaseName> <influxUrl> <influxUserName> <influxPassword>");
        }
    }
}

