/*
 * Decompiled with CFR 0.152.
 */
package org.mule.flatfile.metadata.schema;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.model.BaseCompositeComponent;
import com.mulesoft.flatfile.schema.model.BaseElementComponent;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SchemaUtils;
import org.mule.flatfile.metadata.schema.TypeConverterFactory;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SegmentHandler {
    private final EdiForm ediForm;
    private final BaseTypeBuilder baseBuilder;
    private final Map<TypeFormatConstants.GenericType, MetadataType> typeConvert;
    private final Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> fieldAnnotators;
    private final Map<Composite, MetadataType> compositeTypes;

    public SegmentHandler(EdiForm form, MetadataFormat format, Map<TypeFormatConstants.GenericType, MetadataType> metaTypes, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this.ediForm = form;
        this.baseBuilder = new BaseTypeBuilder(format);
        this.typeConvert = metaTypes;
        this.fieldAnnotators = annoFacts;
        this.compositeTypes = new HashMap<Composite, MetadataType>();
    }

    public SegmentHandler(EdiForm form, MetadataFormat format, Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> annoFacts) {
        this(form, format, TypeConverterFactory.buildTypeConverter(format), annoFacts);
    }

    public void buildSegment(Segment seg, ObjectTypeBuilder typeBuilder) {
        List comps = JavaConverters.seqAsJavaList((Seq)seg.components());
        new SegmentComponentsFieldFactory(comps, false).execute(typeBuilder);
    }

    private class SegmentComponentsFieldFactory {
        private final List<SegmentComponent> components;
        private final boolean forceOptional;

        public SegmentComponentsFieldFactory(List<SegmentComponent> comps, boolean optional) {
            this.components = comps;
            this.forceOptional = optional;
        }

        public void execute(ObjectTypeBuilder object) {
            this.addComponentFields(object, this.components);
        }

        private void addComponentField(ObjectTypeBuilder object, SegmentComponent comp) {
            if (comp.usage().userValue()) {
                Element element = ((BaseElementComponent)comp).element();
                TypeFormat typeFormat = element.typeFormat();
                TypeFormatConstants.GenericType typeCode = typeFormat.genericType();
                MetadataType metadataType = (MetadataType)SegmentHandler.this.typeConvert.get(typeCode);
                ObjectFieldTypeBuilder fieldBuilder = object.addField();
                if (comp.count() == 1) {
                    fieldBuilder.key(comp.key());
                    fieldBuilder.value(metadataType);
                    FieldAnnotationFactory fieldAnnotationFactory = (FieldAnnotationFactory)SegmentHandler.this.fieldAnnotators.get(typeCode);
                    if (fieldAnnotationFactory != null) {
                        TypeAnnotation typeAnnotation = fieldAnnotationFactory.create(typeFormat);
                        fieldBuilder.with(typeAnnotation);
                    }
                } else {
                    fieldBuilder.key(comp.key());
                    fieldBuilder.value().arrayType().of(metadataType);
                }
                this.setUsageDetails(comp, fieldBuilder);
            }
        }

        private MetadataType buildComposite(List<SegmentComponent> comps, ObjectTypeBuilder builder) {
            new SegmentComponentsFieldFactory(comps, false).execute(builder);
            return builder.build();
        }

        private MetadataType getComposite(Composite composite) {
            MetadataType type = (MetadataType)SegmentHandler.this.compositeTypes.get(composite);
            if (type == null) {
                List subcomps = JavaConverters.seqAsJavaList((Seq)composite.components());
                type = this.buildComposite(subcomps, SegmentHandler.this.baseBuilder.objectType());
                SegmentHandler.this.compositeTypes.put(composite, type);
            }
            return type;
        }

        private void addComponentFields(ObjectTypeBuilder object, List<SegmentComponent> comps) {
            for (SegmentComponent comp : comps) {
                if (!SchemaUtils.includeForUsage(comp.usage())) continue;
                if (comp instanceof BaseElementComponent) {
                    this.addComponentField(object, comp);
                    continue;
                }
                if (comp instanceof BaseCompositeComponent) {
                    Composite composite = ((BaseCompositeComponent)comp).composite();
                    List subcomps = JavaConverters.seqAsJavaList((Seq)composite.components());
                    if (comp.count() == 1 && SegmentHandler.this.ediForm.inlineComposites()) {
                        new SegmentComponentsFieldFactory(subcomps, !comp.usage().isMandatory()).execute(object);
                        continue;
                    }
                    ObjectFieldTypeBuilder fieldBuilder = object.addField();
                    fieldBuilder.key(comp.key());
                    if (comp.count() == 1) {
                        fieldBuilder.value(this.getComposite(composite));
                    } else {
                        fieldBuilder.value().arrayType().of(this.getComposite(composite));
                    }
                    this.setUsageDetails(comp, fieldBuilder);
                    continue;
                }
                throw new IllegalStateException("Segment component of unknown type");
            }
        }

        private void setUsageDetails(SegmentComponent comp, ObjectFieldTypeBuilder fieldBuilder) {
            fieldBuilder.description(comp.name());
            if (!this.forceOptional && comp.usage().isMandatory()) {
                fieldBuilder.required();
            }
        }
    }
}

