/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.antlr;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimePeriodImpl;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ASTUtil {
    private static Log log = LogFactory.getLog(ASTUtil.class);
    private static final String PROPERTY_ENABLED_AST_DUMP = "ENABLE_AST_DUMP";

    public static Tree findFirstNode(Tree parent, int type) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree child = parent.getChild(i);
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    public static void dumpAST(Tree ast) {
        if (System.getProperty(PROPERTY_ENABLED_AST_DUMP) != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ASTUtil.renderNode(new char[0], ast, printer);
            ASTUtil.dumpAST(printer, ast, 2);
            log.info((Object)(".dumpAST ANTLR Tree dump follows...\n" + writer.toString()));
        }
    }

    private static void dumpAST(PrintWriter printer, Tree ast, int ident) {
        char[] identChars = new char[ident];
        Arrays.fill(identChars, ' ');
        if (ast == null) {
            ASTUtil.renderNode(identChars, null, printer);
            return;
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            Tree node = ast.getChild(i);
            if (node == null) {
                throw new NullPointerException("Null AST node");
            }
            ASTUtil.renderNode(identChars, node, printer);
            ASTUtil.dumpAST(printer, node, ident + 2);
        }
    }

    public static void printTokens(CommonTokenStream tokens) {
        if (log.isDebugEnabled()) {
            List tokenList = tokens.getTokens();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            for (int i = 0; i < tokens.size(); ++i) {
                Token t = (Token)tokenList.get(i);
                String text = t.getText();
                if (text.trim().length() == 0) {
                    printer.print("'" + text + "'");
                } else {
                    printer.print(text);
                }
                printer.print('[');
                printer.print(t.getType());
                printer.print(']');
                printer.print(" ");
            }
            printer.println();
            log.debug((Object)("Tokens: " + writer.toString()));
        }
    }

    private static void renderNode(char[] ident, Tree node, PrintWriter printer) {
        printer.print(ident);
        if (node == null) {
            printer.print("NULL NODE");
        } else {
            printer.print(node.getText());
            printer.print(" [");
            printer.print(node.getType());
            printer.print("]");
            if (node.getText() == null) {
                printer.print(" (null value in text)");
            } else if (node.getText().contains("\\")) {
                int count = 0;
                for (int i = 0; i < node.getText().length(); ++i) {
                    if (node.getText().charAt(i) != '\\') continue;
                    ++count;
                }
                printer.print(" (" + count + " backlashes)");
            }
        }
        printer.println();
    }

    public static ExprNode getRemoveExpr(Tree child, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode thisEvalNode = astExprNodeMap.get(child);
        astExprNodeMap.remove(child);
        return thisEvalNode;
    }

    public static String getExpressionText(CommonTokenStream tokenStream, Tree node) {
        int startIndex = node.getTokenStartIndex();
        int stopIndex = node.getTokenStopIndex();
        return tokenStream.toString(startIndex, stopIndex);
    }

    public static List<ExprNode> getRemoveAllChildExpr(Tree parent, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ExprNode> expressions = new ArrayList<ExprNode>(parent.getChildCount());
        for (int i = 0; i < parent.getChildCount(); ++i) {
            expressions.add(astExprNodeMap.remove(parent.getChild(i)));
        }
        return expressions;
    }

    public static FilterSpecRaw walkFilterSpec(Tree node, PropertyEvalSpec propertyEvalSpec, Map<Tree, ExprNode> astExprNodeMap) {
        int count = 0;
        Tree startNode = node.getChild(0);
        if (startNode.getType() == 305) {
            startNode = node.getChild(++count);
        }
        String eventName = startNode.getText();
        if (node.getChildCount() > ++count && node.getChild(count).getType() == 139) {
            ++count;
        }
        List<ExprNode> exprNodes = ASTUtil.getExprNodes(node, count, astExprNodeMap);
        return new FilterSpecRaw(eventName, exprNodes, propertyEvalSpec);
    }

    public static List<ExprNode> getExprNodes(Tree parentNode, int startIndex, Map<Tree, ExprNode> astExprNodeMap) {
        LinkedList<ExprNode> exprNodes = new LinkedList<ExprNode>();
        for (int i = startIndex; i < parentNode.getChildCount(); ++i) {
            Tree currentNode = parentNode.getChild(i);
            ExprNode exprNode = astExprNodeMap.get(currentNode);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
            }
            exprNodes.add(exprNode);
            astExprNodeMap.remove(currentNode);
        }
        return exprNodes;
    }

    public static ExprTimePeriod getTimePeriodExpr(Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode[] nodes = new ExprNode[8];
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() == 213) {
                nodes[7] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 212) {
                nodes[6] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 211) {
                nodes[5] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 210) {
                nodes[4] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 209) {
                nodes[3] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 208) {
                nodes[2] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 207) {
                nodes[1] = astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() != 206) continue;
            nodes[0] = astExprNodeMap.remove(child.getChild(0));
        }
        ExprTimePeriodImpl timeNode = new ExprTimePeriodImpl(nodes[0] != null, nodes[1] != null, nodes[2] != null, nodes[3] != null, nodes[4] != null, nodes[5] != null, nodes[6] != null, nodes[7] != null);
        if (nodes[0] != null) {
            timeNode.addChildNode(nodes[0]);
        }
        if (nodes[1] != null) {
            timeNode.addChildNode(nodes[1]);
        }
        if (nodes[2] != null) {
            timeNode.addChildNode(nodes[2]);
        }
        if (nodes[3] != null) {
            timeNode.addChildNode(nodes[3]);
        }
        if (nodes[4] != null) {
            timeNode.addChildNode(nodes[4]);
        }
        if (nodes[5] != null) {
            timeNode.addChildNode(nodes[5]);
        }
        if (nodes[6] != null) {
            timeNode.addChildNode(nodes[6]);
        }
        if (nodes[7] != null) {
            timeNode.addChildNode(nodes[7]);
        }
        return timeNode;
    }
}

