/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.type.StringPatternSet;
import com.espertech.esper.type.StringPatternSetLike;
import com.espertech.esper.type.StringPatternSetRegex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationMetricsReporting
implements Serializable {
    private boolean enableMetricsReporting = false;
    private boolean isThreading = true;
    private long engineInterval = 10000L;
    private long statementInterval = 10000L;
    private Map<String, StmtGroupMetrics> statementGroups = new LinkedHashMap<String, StmtGroupMetrics>();
    private static final long serialVersionUID = -7265780298667075895L;

    public void addStmtGroup(String name, StmtGroupMetrics config) {
        this.statementGroups.put(name, config);
    }

    public boolean isEnableMetricsReporting() {
        return this.enableMetricsReporting;
    }

    public void setEnableMetricsReporting(boolean enableMetricsReporting) {
        this.enableMetricsReporting = enableMetricsReporting;
    }

    public boolean isThreading() {
        return this.isThreading;
    }

    public void setThreading(boolean threading) {
        this.isThreading = threading;
    }

    public long getEngineInterval() {
        return this.engineInterval;
    }

    public void setEngineInterval(long engineInterval) {
        this.engineInterval = engineInterval;
    }

    public long getStatementInterval() {
        return this.statementInterval;
    }

    public void setStatementInterval(long statementInterval) {
        this.statementInterval = statementInterval;
    }

    public Map<String, StmtGroupMetrics> getStatementGroups() {
        return this.statementGroups;
    }

    public void setStatementGroupInterval(String stmtGroupName, long newInterval) {
        StmtGroupMetrics metrics = this.statementGroups.get(stmtGroupName);
        if (metrics == null) {
            throw new ConfigurationException("Statement group by name '" + stmtGroupName + "' could not be found");
        }
        metrics.setInterval(newInterval);
    }

    public static class StmtGroupMetrics
    implements Serializable {
        private List<Pair<StringPatternSet, Boolean>> patterns = new ArrayList<Pair<StringPatternSet, Boolean>>();
        private int numStatements = 100;
        private long interval = 10000L;
        private boolean reportInactive;
        private boolean defaultInclude;
        private static final long serialVersionUID = 5449418752480520879L;

        public void addIncludeLike(String likeExpression) {
            this.patterns.add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(likeExpression), true));
        }

        public void addExcludeLike(String likeExpression) {
            this.patterns.add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(likeExpression), false));
        }

        public void addIncludeRegex(String regexExpression) {
            this.patterns.add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(regexExpression), true));
        }

        public void addExcludeRegEx(String regexExpression) {
            this.patterns.add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(regexExpression), false));
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public List<Pair<StringPatternSet, Boolean>> getPatterns() {
            return this.patterns;
        }

        public int getNumStatements() {
            return this.numStatements;
        }

        public void setNumStatements(int numStatements) {
            this.numStatements = numStatements;
        }

        public boolean isReportInactive() {
            return this.reportInactive;
        }

        public void setReportInactive(boolean reportInactive) {
            this.reportInactive = reportInactive;
        }

        public boolean isDefaultInclude() {
            return this.defaultInclude;
        }

        public void setDefaultInclude(boolean defaultInclude) {
            this.defaultInclude = defaultInclude;
        }
    }
}

