/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.annotation;

import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public enum AuditEnum {
    PROPERTY("PROPERTY"),
    EXPRESSION("EXPRESSION"),
    EXPRESSION_NESTED("EXPRESSION-NESTED"),
    EXPRDEF("EXPRDEF"),
    VIEW("VIEW"),
    PATTERN("PATTERN"),
    PATTERNINSTANCES("PATTERN-INSTANCES"),
    STREAM("STREAM"),
    SCHEDULE("SCHEDULE");

    private final String value;

    private AuditEnum(String value) {
        this.value = value.toUpperCase();
    }

    public String getValue() {
        return this.value;
    }

    public Audit getAudit(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Audit)) continue;
            Audit auditAnnotation = (Audit)annotation;
            String auditAnnoValue = auditAnnotation.value();
            if (auditAnnoValue.equals("*")) {
                return auditAnnotation;
            }
            boolean isListed = AnnotationUtil.isListed(auditAnnoValue, this.value);
            if (!isListed) continue;
            return auditAnnotation;
        }
        return null;
    }
}

