/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.annotation;

import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.epl.annotation.AnnotationException;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public enum HintEnum {
    ITERATE_ONLY("ITERATE_ONLY", false, false),
    DISABLE_RECLAIM_GROUP("DISABLE_RECLAIM_GROUP", false, false),
    RECLAIM_GROUP_AGED("RECLAIM_GROUP_AGED", true, true),
    RECLAIM_GROUP_FREQ("RECLAIM_GROUP_FREQ", true, true),
    ENABLE_WINDOW_SUBQUERY_INDEXSHARE("ENABLE_WINDOW_SUBQUERY_INDEXSHARE", false, false),
    DISABLE_WINDOW_SUBQUERY_INDEXSHARE("DISABLE_WINDOW_SUBQUERY_INDEXSHARE", false, false),
    SET_NOINDEX("SET_NOINDEX", false, false),
    FORCE_NESTED_ITER("FORCE_NESTED_ITER", false, false),
    PREFER_MERGE_JOIN("PREFER_MERGE_JOIN", false, false);

    private final String value;
    private final boolean acceptsParameters;
    private final boolean requiresParameters;

    private HintEnum(String value, boolean acceptsParameters, boolean requiresParameters) {
        this.value = value.toUpperCase();
        this.acceptsParameters = acceptsParameters;
        this.requiresParameters = acceptsParameters ? true : requiresParameters;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAcceptsParameters() {
        return this.acceptsParameters;
    }

    public boolean isRequiresParameters() {
        return this.requiresParameters;
    }

    public Hint getHint(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            Hint hintAnnotation;
            boolean isListed;
            if (!(annotation instanceof Hint) || !(isListed = AnnotationUtil.isListed((hintAnnotation = (Hint)annotation).value(), this.value))) continue;
            return hintAnnotation;
        }
        return null;
    }

    public String getHintAssignedValue(Hint hintAnnotation) {
        if (!this.acceptsParameters) {
            return null;
        }
        return AnnotationUtil.getAssignedValue(hintAnnotation.value(), this.value);
    }

    public static void validate(Annotation annotation) throws AnnotationException {
        if (!(annotation instanceof Hint)) {
            return;
        }
        Hint hint = (Hint)annotation;
        for (HintEnum val : HintEnum.values()) {
            if (!val.getValue().equals(hint.value().trim().toUpperCase())) continue;
            HintEnum.validateParameters(val, hint.value().trim());
            return;
        }
        String[] hints = hint.value().split(",");
        for (int i = 0; i < hints.length; ++i) {
            String hintVal = hints[i].trim().toUpperCase();
            HintEnum found = null;
            for (HintEnum val : HintEnum.values()) {
                if (val.getValue().equals(hintVal)) {
                    found = val;
                    break;
                }
                if (hintVal.indexOf(61) == -1) continue;
                String hintName = hintVal.substring(0, hintVal.indexOf(61));
                if (!val.getValue().equals(hintName.trim().toUpperCase())) continue;
                found = val;
                break;
            }
            if (found == null) {
                String hintName = hints[i].trim();
                if (hintName.indexOf(61) != -1) {
                    hintName = hintName.substring(0, hintName.indexOf(61));
                }
                throw new AnnotationException("Hint annotation value '" + hintName.trim() + "' is not one of the known values");
            }
            HintEnum.validateParameters(found, hintVal);
        }
    }

    private static void validateParameters(HintEnum val, String hintVal) throws AnnotationException {
        if (val.isRequiresParameters() && hintVal.indexOf(61) == -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' requires a parameter value");
        }
        if (!val.isAcceptsParameters() && hintVal.indexOf(61) != -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' does not accept a parameter value");
        }
    }
}

