/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public abstract class AccessProjectionExpressionBase
extends ExpressionBase {
    private static final long serialVersionUID = 6858302558659972064L;
    private boolean wildcard;
    private String streamWildcard;

    public AccessProjectionExpressionBase() {
    }

    public abstract String getAggregationFunctionName();

    public AccessProjectionExpressionBase(Expression expression) {
        this.getChildren().add(expression);
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public String getStreamWildcard() {
        return this.streamWildcard;
    }

    public void setStreamWildcard(String streamWildcard) {
        this.streamWildcard = streamWildcard;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        List<Expression> children;
        writer.write(this.getAggregationFunctionName());
        writer.write(40);
        String delimiter = "";
        if (this.wildcard) {
            writer.write(42);
            delimiter = ", ";
        }
        if (this.streamWildcard != null) {
            writer.write(this.streamWildcard);
            writer.write(".*");
            delimiter = ", ";
        }
        if ((children = this.getChildren()).size() > 0) {
            writer.write(delimiter);
            children.get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            for (int i = 1; i < children.size(); ++i) {
                writer.write(", ");
                children.get(i).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            }
        }
        writer.write(")");
    }
}

