/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ContextDescriptor;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.Filter;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternExprPrecedenceEnum;
import com.espertech.esper.client.soda.TimePeriodExpression;
import java.io.StringWriter;
import java.util.List;

public class ContextDescriptorInitiatedTerminated
implements ContextDescriptor {
    private static final long serialVersionUID = 8998560999403352926L;
    private Filter initiatedFilter;
    private String initiatedFilterAsName;
    private PatternExpr initiatedPattern;
    private Expression terminatedTimePeriod;

    public ContextDescriptorInitiatedTerminated() {
    }

    public ContextDescriptorInitiatedTerminated(PatternExpr initiatedPattern, TimePeriodExpression terminatedTimePeriod) {
        this.initiatedPattern = initiatedPattern;
        this.terminatedTimePeriod = terminatedTimePeriod;
    }

    public ContextDescriptorInitiatedTerminated(Filter initiatedFilter, String initiatedFilterAsName, TimePeriodExpression terminatedTimePeriod) {
        this.initiatedFilter = initiatedFilter;
        this.initiatedFilterAsName = initiatedFilterAsName;
        this.terminatedTimePeriod = terminatedTimePeriod;
    }

    public Filter getInitiatedFilter() {
        return this.initiatedFilter;
    }

    public void setInitiatedFilter(Filter initiatedFilter) {
        this.initiatedFilter = initiatedFilter;
    }

    public String getInitiatedFilterAsName() {
        return this.initiatedFilterAsName;
    }

    public void setInitiatedFilterAsName(String initiatedFilterAsName) {
        this.initiatedFilterAsName = initiatedFilterAsName;
    }

    public PatternExpr getInitiatedPattern() {
        return this.initiatedPattern;
    }

    public void setInitiatedPattern(PatternExpr initiatedPattern) {
        this.initiatedPattern = initiatedPattern;
    }

    public Expression getTerminatedTimePeriod() {
        return this.terminatedTimePeriod;
    }

    public void setTerminatedTimePeriod(Expression terminatedTimePeriod) {
        this.terminatedTimePeriod = terminatedTimePeriod;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.append("initiated by ");
        if (this.initiatedFilter != null) {
            this.initiatedFilter.toEPL(writer, formatter);
            writer.append(" as ");
            writer.append(this.initiatedFilterAsName);
        } else {
            writer.append("pattern [");
            this.initiatedPattern.toEPL(writer, PatternExprPrecedenceEnum.MINIMUM, formatter);
            writer.append("]");
        }
        writer.append(" terminated after ");
        this.terminatedTimePeriod.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
    }

    private static void write(StringWriter writer, String label, List<Expression> expressions) {
        writer.append(label);
        writer.append(" (");
        String delimiter = "";
        for (Expression e : expressions) {
            writer.append(delimiter);
            e.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.append(")");
    }
}

