/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.CreateIndexColumn;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class CreateIndexClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String indexName;
    private String windowName;
    private List<CreateIndexColumn> columns = new ArrayList<CreateIndexColumn>();

    public CreateIndexClause() {
    }

    public static CreateIndexClause create(String indexName, String windowName, String ... properties) {
        return new CreateIndexClause(indexName, windowName, properties);
    }

    public CreateIndexClause(String indexName, String windowName, List<CreateIndexColumn> columns) {
        this.indexName = indexName;
        this.windowName = windowName;
        this.columns = columns;
    }

    public CreateIndexClause(String indexName, String windowName, String[] properties) {
        this.indexName = indexName;
        this.windowName = windowName;
        for (String prop : properties) {
            this.columns.add(new CreateIndexColumn(prop));
        }
    }

    public void toEPL(StringWriter writer) {
        writer.write("create index ");
        writer.write(this.indexName);
        writer.write(" on ");
        writer.write(this.windowName);
        writer.write(40);
        String delimiter = "";
        for (CreateIndexColumn prop : this.columns) {
            writer.write(delimiter);
            prop.toEPL(writer);
            delimiter = ", ";
        }
        writer.write(41);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<CreateIndexColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<CreateIndexColumn> columns) {
        this.columns = columns;
    }
}

