/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.SchemaColumnDesc;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;

public class CreateSchemaClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String schemaName;
    private Set<String> types;
    private List<SchemaColumnDesc> columns;
    private Set<String> inherits;
    private boolean variant;
    private String startTimestampPropertyName;
    private String endTimestampPropertyName;
    private Set<String> copyFrom;

    public CreateSchemaClause() {
    }

    public CreateSchemaClause(String schemaName, Set<String> types, boolean variant) {
        this.schemaName = schemaName;
        this.types = types;
        this.variant = variant;
    }

    public CreateSchemaClause(String schemaName, List<SchemaColumnDesc> columns, Set<String> inherits) {
        this.schemaName = schemaName;
        this.columns = columns;
        this.inherits = inherits;
    }

    public CreateSchemaClause(String schemaName, Set<String> types, List<SchemaColumnDesc> columns, Set<String> inherits, boolean variant) {
        this.schemaName = schemaName;
        this.types = types;
        this.columns = columns;
        this.inherits = inherits;
        this.variant = variant;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public void setTypes(Set<String> types) {
        this.types = types;
    }

    public List<SchemaColumnDesc> getColumns() {
        return this.columns;
    }

    public void setColumns(List<SchemaColumnDesc> columns) {
        this.columns = columns;
    }

    public Set<String> getInherits() {
        return this.inherits;
    }

    public void setInherits(Set<String> inherits) {
        this.inherits = inherits;
    }

    public boolean isVariant() {
        return this.variant;
    }

    public void setVariant(boolean variant) {
        this.variant = variant;
    }

    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    public void setStartTimestampPropertyName(String startTimestampPropertyName) {
        this.startTimestampPropertyName = startTimestampPropertyName;
    }

    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    public Set<String> getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(Set<String> copyFrom) {
        this.copyFrom = copyFrom;
    }

    public void setEndTimestampPropertyName(String endTimestampPropertyName) {
        this.endTimestampPropertyName = endTimestampPropertyName;
    }

    public void toEPL(StringWriter writer) {
        String delimiter;
        writer.append("create");
        if (this.variant) {
            writer.append(" variant");
        }
        writer.append(" schema ");
        writer.append(this.schemaName);
        writer.append(" as ");
        if (this.types != null && !this.types.isEmpty()) {
            delimiter = "";
            for (String type : this.types) {
                writer.append(delimiter);
                writer.append(type);
                delimiter = ", ";
            }
        } else {
            writer.append("(");
            delimiter = "";
            for (SchemaColumnDesc col : this.columns) {
                writer.append(delimiter);
                col.toEPL(writer);
                delimiter = ", ";
            }
            writer.append(")");
        }
        if (this.inherits != null && !this.inherits.isEmpty()) {
            writer.append(" inherits ");
            delimiter = "";
            for (String name : this.inherits) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ", ";
            }
        }
        if (this.startTimestampPropertyName != null) {
            writer.append(" starttimestamp ");
            writer.append(this.startTimestampPropertyName);
        }
        if (this.endTimestampPropertyName != null) {
            writer.append(" endtimestamp ");
            writer.append(this.endTimestampPropertyName);
        }
        if (this.copyFrom != null && !this.copyFrom.isEmpty()) {
            writer.append(" copyFrom ");
            delimiter = "";
            for (String name : this.copyFrom) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ", ";
            }
        }
    }
}

