/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OuterJoinQualifier;
import com.espertech.esper.client.soda.PropertyValueExpressionPair;
import com.espertech.esper.client.soda.Stream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FromClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<Stream> streams = new ArrayList<Stream>();
    private List<OuterJoinQualifier> outerJoinQualifiers = new ArrayList<OuterJoinQualifier>();

    public FromClause() {
    }

    public static FromClause create() {
        return new FromClause();
    }

    public static FromClause create(Stream stream, OuterJoinQualifier outerJoinQualifier, Stream streamSecond) {
        return new FromClause(stream, outerJoinQualifier, streamSecond);
    }

    public static FromClause create(Stream ... streams) {
        return new FromClause(streams);
    }

    public FromClause(Stream streamOne, OuterJoinQualifier outerJoinQualifier, Stream streamTwo) {
        this(streamOne);
        this.add(streamTwo);
        this.outerJoinQualifiers.add(outerJoinQualifier);
    }

    public FromClause(Stream ... streamsList) {
        this.streams.addAll(Arrays.asList(streamsList));
    }

    public FromClause add(Stream stream) {
        this.streams.add(stream);
        return this;
    }

    public FromClause add(OuterJoinQualifier outerJoinQualifier) {
        this.outerJoinQualifiers.add(outerJoinQualifier);
        return this;
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        this.toEPLOptions(writer, formatter, true);
    }

    protected void toEPLOptions(StringWriter writer, EPStatementFormatter formatter, boolean includeFrom) {
        String delimiter = "";
        if (includeFrom) {
            formatter.beginFrom(writer);
            writer.write("from");
        }
        if (this.outerJoinQualifiers == null || this.outerJoinQualifiers.size() == 0) {
            boolean first = true;
            for (Stream stream : this.streams) {
                writer.write(delimiter);
                formatter.beginFromStream(writer, first);
                first = false;
                stream.toEPL(writer, formatter);
                delimiter = ",";
            }
        } else {
            if (this.outerJoinQualifiers.size() != this.streams.size() - 1) {
                throw new IllegalArgumentException("Number of outer join qualifiers must be one less then the number of streams.");
            }
            boolean first = true;
            for (int i = 0; i < this.streams.size(); ++i) {
                Stream stream = this.streams.get(i);
                formatter.beginFromStream(writer, first);
                first = false;
                stream.toEPL(writer, formatter);
                if (i > 0) {
                    OuterJoinQualifier qualCond = this.outerJoinQualifiers.get(i - 1);
                    writer.write(" on ");
                    qualCond.getLeft().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                    writer.write(" = ");
                    qualCond.getRight().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                    if (qualCond.getAdditionalProperties().size() > 0) {
                        for (PropertyValueExpressionPair pair : qualCond.getAdditionalProperties()) {
                            writer.write(" and ");
                            pair.getLeft().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                            writer.write(" = ");
                            pair.getRight().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                        }
                    }
                }
                if (i >= this.streams.size() - 1) continue;
                OuterJoinQualifier qualType = this.outerJoinQualifiers.get(i);
                writer.write(" ");
                writer.write(qualType.getType().getText());
                writer.write(" outer join");
            }
        }
    }

    public List<OuterJoinQualifier> getOuterJoinQualifiers() {
        return this.outerJoinQualifiers;
    }

    public void setStreams(List<Stream> streams) {
        this.streams = streams;
    }

    public void setOuterJoinQualifiers(List<OuterJoinQualifier> outerJoinQualifiers) {
        this.outerJoinQualifiers = outerJoinQualifiers;
    }
}

