/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class MaxProjectionExpression
extends ExpressionBase {
    private boolean distinct;
    private static final long serialVersionUID = -2052925266576308551L;

    public MaxProjectionExpression() {
    }

    public MaxProjectionExpression(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public MaxProjectionExpression(Expression expression, boolean isDistinct) {
        this.distinct = isDistinct;
        this.getChildren().add(expression);
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getChildren().size() > 1) {
            writer.write("fmax(");
        } else {
            writer.write("max(");
        }
        if (this.distinct) {
            writer.write("distinct ");
        }
        String delimiter = "";
        for (Expression param : this.getChildren()) {
            writer.write(delimiter);
            delimiter = ", ";
            param.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(")");
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }
}

