/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnMergeMatchedAction;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;

public class OnMergeMatchedUpdateAction
implements OnMergeMatchedAction {
    private static final long serialVersionUID = 0L;
    private List<AssignmentPair> assignments = Collections.emptyList();
    private Expression whereClause;

    public OnMergeMatchedUpdateAction() {
    }

    public OnMergeMatchedUpdateAction(List<AssignmentPair> assignments, Expression whereClause) {
        this.assignments = assignments;
        this.whereClause = whereClause;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public List<AssignmentPair> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<AssignmentPair> assignments) {
        this.assignments = assignments;
    }

    @Override
    public void toEPL(StringWriter writer) {
        writer.write("then update set ");
        String delimiter = "";
        for (AssignmentPair pair : this.assignments) {
            writer.write(delimiter);
            writer.write(pair.getName());
            writer.write(" = ");
            pair.getValue().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        if (this.whereClause != null) {
            writer.write(" where ");
            this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }
}

