/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnClause;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OnSetClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private List<AssignmentPair> assignments = new ArrayList<AssignmentPair>();

    public static OnSetClause create(String variableName, Expression expression) {
        OnSetClause clause = new OnSetClause();
        clause.addAssignment(variableName, expression);
        return clause;
    }

    public OnSetClause addAssignment(String variable, Expression expression) {
        this.assignments.add(new AssignmentPair(variable, expression));
        return this;
    }

    public List<AssignmentPair> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<AssignmentPair> assignments) {
        this.assignments = assignments;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        formatter.beginOnSet(writer);
        writer.write("set ");
        String delimiter = "";
        for (AssignmentPair pair : this.assignments) {
            writer.write(delimiter);
            writer.write(pair.getName());
            writer.write(" = ");
            pair.getValue().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
    }
}

