/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateTime {
    private static final Log log = LogFactory.getLog(DateTime.class);

    public static Calendar toCalendar(String datestring) {
        return DateTime.parseGetCal(datestring, new SimpleDateFormat());
    }

    public static Calendar toCalendar(String datestring, String format) {
        Date d = DateTime.parse(datestring, format);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return cal;
    }

    public static Date toDate(String datestring) {
        return DateTime.parse(datestring);
    }

    public static Date toDate(String datestring, String format) {
        return DateTime.parse(datestring, format);
    }

    public static Long toMillisec(String datestring) {
        Date date = DateTime.parse(datestring);
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long toMillisec(String datestring, String format) {
        Date date = DateTime.parse(datestring, format);
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    private static Date parse(String str) {
        return DateTime.parse(str, new SimpleDateFormat());
    }

    private static Date parse(String str, String format) {
        SimpleDateFormat sdf;
        try {
            sdf = new SimpleDateFormat(format);
        }
        catch (Exception ex) {
            log.warn((Object)("Error in date format '" + str + "': " + ex.getMessage()), (Throwable)ex);
            return null;
        }
        return DateTime.parse(str, sdf);
    }

    private static Date parse(String str, SimpleDateFormat format) {
        Date d;
        try {
            d = format.parse(str);
        }
        catch (ParseException e) {
            log.warn((Object)("Error parsing date '" + str + "' according to format '" + format.toPattern() + "': " + e.getMessage()), (Throwable)e);
            return null;
        }
        return d;
    }

    private static Calendar parseGetCal(String str, SimpleDateFormat format) {
        Date d = DateTime.parse(str, format);
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return cal;
    }
}

