/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;

public class RollingEventBuffer {
    private int size;
    private EventBean[] buffer;
    private int nextFreeIndex;

    public RollingEventBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Minimum buffer size is 1");
        }
        this.size = size;
        this.nextFreeIndex = 0;
        this.buffer = new EventBean[size];
    }

    public void add(EventBean[] events) {
        if (events == null) {
            return;
        }
        for (int i = 0; i < events.length; ++i) {
            this.add(events[i]);
        }
    }

    public void add(EventBean event) {
        this.buffer[this.nextFreeIndex] = event;
        ++this.nextFreeIndex;
        if (this.nextFreeIndex == this.size) {
            this.nextFreeIndex = 0;
        }
    }

    public EventBean get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index + " for size " + this.size);
        }
        int newest = this.nextFreeIndex - 1;
        int relative = newest - index;
        if (relative < 0) {
            relative += this.size;
        }
        return this.buffer[relative];
    }
}

