/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.TimeWindowIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TimeWindow
implements Iterable {
    private final ArrayDeque<Pair<Long, ArrayDeque<EventBean>>> window = new ArrayDeque();
    private Long oldestTimestamp = null;
    private Map<EventBean, ArrayDeque<EventBean>> reverseIndex;

    public TimeWindow(boolean isSupportRemoveStream) {
        if (isSupportRemoveStream) {
            this.reverseIndex = new HashMap<EventBean, ArrayDeque<EventBean>>();
        }
    }

    public void adjust(long delta) {
        for (Pair<Long, ArrayDeque<EventBean>> data : this.window) {
            data.setFirst(data.getFirst() + delta);
        }
        if (this.oldestTimestamp != null) {
            this.oldestTimestamp = this.oldestTimestamp + delta;
        }
    }

    public final void add(long timestamp, EventBean bean) {
        if (this.oldestTimestamp == null) {
            this.oldestTimestamp = timestamp;
        }
        if (this.window.isEmpty()) {
            ArrayDeque<EventBean> listOfBeans = new ArrayDeque<EventBean>();
            listOfBeans.add(bean);
            Pair pair = new Pair(timestamp, listOfBeans);
            this.window.add(pair);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, listOfBeans);
            }
            return;
        }
        Pair<Long, ArrayDeque<EventBean>> lastPair = this.window.getLast();
        if (lastPair.getFirst() == timestamp) {
            lastPair.getSecond().add(bean);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, lastPair.getSecond());
            }
            return;
        }
        ArrayDeque<EventBean> listOfBeans = new ArrayDeque<EventBean>();
        listOfBeans.add(bean);
        Pair pair = new Pair(timestamp, listOfBeans);
        if (this.reverseIndex != null) {
            this.reverseIndex.put(bean, listOfBeans);
        }
        this.window.add(pair);
    }

    public final void remove(EventBean event) {
        if (this.reverseIndex == null) {
            throw new UnsupportedOperationException("Time window does not accept event removal");
        }
        ArrayDeque<EventBean> list = this.reverseIndex.get(event);
        if (list != null) {
            list.remove(event);
        }
        this.reverseIndex.remove(event);
    }

    public final ArrayDeque<EventBean> expireEvents(long expireBefore) {
        if (this.window.isEmpty()) {
            return null;
        }
        Pair<Long, ArrayDeque<EventBean>> pair = this.window.getFirst();
        if (pair.getFirst() >= expireBefore) {
            return null;
        }
        ArrayDeque<EventBean> resultBeans = new ArrayDeque<EventBean>();
        do {
            resultBeans.addAll((Collection)pair.getSecond());
            this.window.removeFirst();
        } while (!this.window.isEmpty() && (pair = this.window.getFirst()).getFirst() < expireBefore);
        this.oldestTimestamp = this.window.isEmpty() ? null : pair.getFirst();
        if (this.reverseIndex != null) {
            for (EventBean expired : resultBeans) {
                this.reverseIndex.remove(expired);
            }
        }
        return resultBeans;
    }

    public final Iterator<EventBean> iterator() {
        return new TimeWindowIterator(this.window);
    }

    public final Long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public final boolean isEmpty() {
        return this.window.isEmpty();
    }

    protected Map<EventBean, ArrayDeque<EventBean>> getReverseIndex() {
        return this.reverseIndex;
    }
}

