/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperUtil;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.join.base.JoinExecStrategyDispatchable;
import com.espertech.esper.epl.join.base.JoinExecutionStrategyImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethod;
import com.espertech.esper.epl.join.base.JoinPreloadMethodImpl;
import com.espertech.esper.epl.join.base.JoinPreloadMethodNull;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.view.FilterExprView;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.BufferView;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import com.espertech.esper.view.internal.SingleStreamDispatchView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceFactorySelect
implements StatementAgentInstanceFactory {
    private static final Log log = LogFactory.getLog(StatementAgentInstanceFactorySelect.class);
    private final int numStreams;
    private final ViewableActivator[] eventStreamParentViewableActivators;
    private final StatementContext statementContext;
    private final StatementSpecCompiled statementSpec;
    private final EPServicesContext services;
    private final StreamTypeService typeService;
    private final ViewFactoryChain[] unmaterializedViewChain;
    private final ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc;
    private final StreamJoinAnalysisResult joinAnalysisResult;
    private final boolean isRecoveringResilient;
    private final JoinSetComposerPrototype joinSetComposerPrototype;
    private final SubSelectStrategyCollection subSelectStrategyCollection;
    private final ViewResourceDelegateVerified viewResourceDelegate;
    private final OutputProcessViewFactory outputProcessViewFactory;

    public StatementAgentInstanceFactorySelect(int numStreams, ViewableActivator[] eventStreamParentViewableActivators, StatementContext statementContext, StatementSpecCompiled statementSpec, EPServicesContext services, StreamTypeService typeService, ViewFactoryChain[] unmaterializedViewChain, ResultSetProcessorFactoryDesc resultSetProcessorFactoryDesc, StreamJoinAnalysisResult joinAnalysisResult, boolean recoveringResilient, JoinSetComposerPrototype joinSetComposerPrototype, SubSelectStrategyCollection subSelectStrategyCollection, ViewResourceDelegateVerified viewResourceDelegate, OutputProcessViewFactory outputProcessViewFactory) {
        this.numStreams = numStreams;
        this.eventStreamParentViewableActivators = eventStreamParentViewableActivators;
        this.statementContext = statementContext;
        this.statementSpec = statementSpec;
        this.services = services;
        this.typeService = typeService;
        this.unmaterializedViewChain = unmaterializedViewChain;
        this.resultSetProcessorFactoryDesc = resultSetProcessorFactoryDesc;
        this.joinAnalysisResult = joinAnalysisResult;
        this.isRecoveringResilient = recoveringResilient;
        this.joinSetComposerPrototype = joinSetComposerPrototype;
        this.subSelectStrategyCollection = subSelectStrategyCollection;
        this.viewResourceDelegate = viewResourceDelegate;
        this.outputProcessViewFactory = outputProcessViewFactory;
    }

    @Override
    public StatementAgentInstanceFactorySelectResult newContext(final AgentInstanceContext agentInstanceContext) {
        Viewable finalView;
        AggregationService aggregationService;
        Map<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies;
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousNodeStrategies;
        Map<ExprPriorNode, ExprPriorEvalStrategy> priorNodeStrategies;
        if (this.services.getSchedulableAgentInstanceDirectory() != null) {
            this.services.getSchedulableAgentInstanceDirectory().add(agentInstanceContext.getEpStatementAgentInstanceHandle());
        }
        final ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>();
        StopCallback stopCallback = new StopCallback(){

            @Override
            public void stop() {
                StatementAgentInstanceUtil.stopSafe(agentInstanceContext.getTerminationCallbacks(), stopCallbacks, StatementAgentInstanceFactorySelect.this.statementContext);
            }
        };
        ViewableActivationResult[] viewableActivationResult = new ViewableActivationResult[this.eventStreamParentViewableActivators.length];
        try {
            int i;
            Viewable[] eventStreamParentViewable = new Viewable[this.numStreams];
            for (int stream = 0; stream < this.eventStreamParentViewableActivators.length; ++stream) {
                ViewableActivationResult activationResult;
                viewableActivationResult[stream] = activationResult = this.eventStreamParentViewableActivators[stream].activate(agentInstanceContext);
                stopCallbacks.add(activationResult.getStopCallback());
                eventStreamParentViewable[stream] = activationResult.getViewable();
                if (activationResult.getOptionalLock() == null) continue;
                agentInstanceContext.getEpStatementAgentInstanceHandle().setStatementAgentInstanceLock(activationResult.getOptionalLock());
                this.statementContext.setDefaultAgentInstanceLock(activationResult.getOptionalLock());
            }
            List[] viewFactoryChains = new List[this.numStreams];
            for (int i2 = 0; i2 < this.numStreams; ++i2) {
                boolean hasPrior;
                List<ViewFactory> viewFactoryChain = this.unmaterializedViewChain[i2].getViewFactoryChain();
                boolean bl = hasPrior = this.viewResourceDelegate.getPerStream()[i2].getPriorRequests() != null && !this.viewResourceDelegate.getPerStream()[i2].getPriorRequests().isEmpty();
                if (hasPrior) {
                    PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.getPriorEventViewFactory(agentInstanceContext.getStatementContext(), i2, viewFactoryChain.size() + 1, viewFactoryChain.isEmpty());
                    viewFactoryChain = new ArrayList<ViewFactory>(viewFactoryChain);
                    viewFactoryChain.add(priorEventViewFactory);
                }
                viewFactoryChains[i2] = viewFactoryChain;
            }
            AgentInstanceViewFactoryChainContext[] viewFactoryChainContexts = new AgentInstanceViewFactoryChainContext[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                viewFactoryChainContexts[i] = AgentInstanceViewFactoryChainContext.create(viewFactoryChains[i], agentInstanceContext, this.viewResourceDelegate.getPerStream()[i]);
            }
            priorNodeStrategies = EPStatementStartMethodHelperPrior.compilePriorNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            previousNodeStrategies = EPStatementStartMethodHelperPrevious.compilePreviousNodeStrategies(this.viewResourceDelegate, viewFactoryChainContexts);
            Viewable[] streamViews = new Viewable[this.numStreams];
            for (i = 0; i < this.numStreams; ++i) {
                boolean hasPreviousNode = this.viewResourceDelegate.getPerStream()[i].getPreviousRequests() != null && !this.viewResourceDelegate.getPerStream()[i].getPreviousRequests().isEmpty();
                streamViews[i] = this.services.getViewService().createViews(eventStreamParentViewable[i], viewFactoryChains[i], viewFactoryChainContexts[i], hasPreviousNode);
            }
            subselectStrategies = EPStatementStartMethodHelperSubselect.startSubselects(this.services, this.subSelectStrategyCollection, agentInstanceContext, stopCallbacks);
            Pair<ResultSetProcessor, AggregationService> processorPair = EPStatementStartMethodHelperUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryDesc, agentInstanceContext);
            ResultSetProcessor resultSetProcessor = processorPair.getFirst();
            aggregationService = processorPair.getSecond();
            JoinPreloadMethod joinPreloadMethod = null;
            if (streamViews.length == 1) {
                finalView = this.handleSimpleSelect(streamViews[0], resultSetProcessor, agentInstanceContext);
            } else {
                Pair<Viewable, JoinPreloadMethod> pair = this.handleJoin(this.typeService.getStreamNames(), streamViews, resultSetProcessor, agentInstanceContext, stopCallbacks, this.joinAnalysisResult);
                finalView = pair.getFirst();
                joinPreloadMethod = pair.getSecond();
            }
            boolean hasNamedWindow = false;
            for (int i3 = 0; i3 < this.statementSpec.getStreamSpecs().size(); ++i3) {
                StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i3);
                if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
                hasNamedWindow = true;
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
                NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(agentInstanceContext);
                if (processorInstance != null) {
                    NamedWindowTailViewInstance consumerView = processorInstance.getTailViewInstance();
                    NamedWindowConsumerView view = (NamedWindowConsumerView)viewableActivationResult[i3].getViewable();
                    ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>();
                    if (!consumerView.getTailView().isParentBatchWindow()) {
                        for (EventBean aConsumerView : consumerView) {
                            eventsInWindow.add(aConsumerView);
                        }
                    }
                    if (!eventsInWindow.isEmpty() && !this.isRecoveringResilient) {
                        EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
                        view.update(newEvents, null);
                        if (joinPreloadMethod != null && !joinPreloadMethod.isPreloading() && agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                            agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute(agentInstanceContext);
                        }
                    }
                } else {
                    log.info((Object)("Named window access is out-of-context, the named window '" + namedSpec.getWindowName() + "' has been declared for a different context then the current statement, the aggregation and join state will not be initialized for statement expression [" + this.statementContext.getExpression() + "]"));
                }
                if (joinPreloadMethod != null) {
                    joinPreloadMethod.preloadFromBuffer(i3);
                    continue;
                }
                if (agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() == null) continue;
                agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute(agentInstanceContext);
            }
            if (hasNamedWindow && joinPreloadMethod != null && !this.isRecoveringResilient && this.resultSetProcessorFactoryDesc.getResultSetProcessorFactory().hasAggregation()) {
                joinPreloadMethod.preloadAggregation(resultSetProcessor);
            }
        }
        catch (RuntimeException ex) {
            StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
            throw ex;
        }
        return new StatementAgentInstanceFactorySelectResult(finalView, stopCallback, agentInstanceContext, aggregationService, subselectStrategies, priorNodeStrategies, previousNodeStrategies);
    }

    private Viewable handleSimpleSelect(Viewable view, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        Viewable finalView = view;
        if (this.statementSpec.getFilterRootNode() != null) {
            FilterExprView filterView = new FilterExprView(this.statementSpec.getFilterRootNode().getExprEvaluator(), agentInstanceContext);
            finalView.addView(filterView);
            finalView = filterView;
        }
        if (!this.statementSpec.getOrderByList().isEmpty() && this.statementSpec.getOutputLimitSpec() == null) {
            SingleStreamDispatchView bf = new SingleStreamDispatchView();
            agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(bf);
            finalView.addView(bf);
            finalView = bf;
        }
        OutputProcessViewBase selectView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        finalView.addView(selectView);
        finalView = selectView;
        return finalView;
    }

    private Pair<Viewable, JoinPreloadMethod> handleJoin(String[] streamNames, Viewable[] streamViews, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbacks, StreamJoinAnalysisResult joinAnalysisResult) {
        final JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(streamViews);
        stopCallbacks.add(new StopCallback(){

            @Override
            public void stop() {
                joinSetComposerDesc.getJoinSetComposer().destroy();
            }
        });
        JoinSetFilter filter = new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator());
        OutputProcessViewBase indicatorView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(joinSetComposerDesc.getJoinSetComposer(), filter, indicatorView, agentInstanceContext);
        indicatorView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, this.statementSpec.getStreamSpecs().size());
        agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethod preloadMethod = joinAnalysisResult.getUnidirectionalStreamNumber() >= 0 ? new JoinPreloadMethodNull() : new JoinPreloadMethodImpl(streamNames.length, joinSetComposerDesc.getJoinSetComposer());
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].addView(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new Pair<Viewable, JoinPreloadMethod>(indicatorView, preloadMethod);
    }
}

