/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdateResult;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.InternalEventRouterDesc;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.util.StopCallback;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceFactoryUpdate
implements StatementAgentInstanceFactory {
    private static final Log log = LogFactory.getLog(StatementAgentInstanceFactoryUpdate.class);
    private final StatementContext statementContext;
    private final EPServicesContext services;
    private final EventType streamEventType;
    private final UpdateDesc desc;
    private final InternalRoutePreprocessView onExprView;
    private final InternalEventRouterDesc routerDesc;
    private final SubSelectStrategyCollection subSelectStrategyCollection;

    public StatementAgentInstanceFactoryUpdate(StatementContext statementContext, EPServicesContext services, EventType streamEventType, UpdateDesc desc, InternalRoutePreprocessView onExprView, InternalEventRouterDesc routerDesc, SubSelectStrategyCollection subSelectStrategyCollection) {
        this.statementContext = statementContext;
        this.services = services;
        this.streamEventType = streamEventType;
        this.desc = desc;
        this.onExprView = onExprView;
        this.subSelectStrategyCollection = subSelectStrategyCollection;
        this.routerDesc = routerDesc;
    }

    @Override
    public StatementAgentInstanceFactoryUpdateResult newContext(final AgentInstanceContext agentInstanceContext) {
        Map<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategies;
        final ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>();
        StopCallback stopCallback = new StopCallback(){

            @Override
            public void stop() {
                StatementAgentInstanceUtil.stopSafe(agentInstanceContext.getTerminationCallbacks(), stopCallbacks, StatementAgentInstanceFactoryUpdate.this.statementContext);
            }
        };
        try {
            stopCallbacks.add(new StopCallback(){

                @Override
                public void stop() {
                    StatementAgentInstanceFactoryUpdate.this.services.getInternalEventRouter().removePreprocessing(StatementAgentInstanceFactoryUpdate.this.streamEventType, StatementAgentInstanceFactoryUpdate.this.desc);
                }
            });
            this.services.getInternalEventRouter().addPreprocessing(this.routerDesc, this.onExprView);
            subselectStrategies = EPStatementStartMethodHelperSubselect.startSubselects(this.services, this.subSelectStrategyCollection, agentInstanceContext, stopCallbacks);
        }
        catch (RuntimeException ex) {
            StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
            throw ex;
        }
        log.debug((Object)".start Statement start completed");
        return new StatementAgentInstanceFactoryUpdateResult(this.onExprView, stopCallback, agentInstanceContext, subselectStrategies);
    }
}

