/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.collection.SafeIteratorNull;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceArraySafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyImpl;
import com.espertech.esper.core.context.mgr.ContextManagedStatementBase;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextManagerPartitionedStatementDesc;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContextManagerCategorized
implements ContextManager,
ContextIteratorHandler {
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final ContextDetailCategory categorySpec;
    private final ContextDescriptor contextDescriptor;
    private final Map<ContextDetailCategoryItem, Integer> instances = new LinkedHashMap<ContextDetailCategoryItem, Integer>();
    private final Map<String, ContextManagerPartitionedStatementDesc> statements = new LinkedHashMap<String, ContextManagerPartitionedStatementDesc>();

    public ContextManagerCategorized(String contextName, EPServicesContext servicesContext, ContextDetailCategory categorySpec) throws ExprValidationException {
        this.contextName = contextName;
        this.servicesContext = servicesContext;
        this.categorySpec = categorySpec;
        this.validateContextDesc(categorySpec);
        StatementAIResourceRegistryFactory resourceRegistryFactory = new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
        EventType contextEventType = ContextPropertyEventType.getCategorizedType(contextName, servicesContext.getEventAdapterService());
        ContextPropertyRegistryImpl contextPropertyRegistry = new ContextPropertyRegistryImpl(contextEventType);
        this.contextDescriptor = new ContextDescriptor(contextName, false, contextPropertyRegistry, resourceRegistryFactory, this);
        int agentInstanceId = 0;
        for (ContextDetailCategoryItem item : categorySpec.getItems()) {
            this.instances.put(item, agentInstanceId);
            ++agentInstanceId;
        }
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public synchronized void safeDestroy() {
    }

    @Override
    public synchronized void addStatement(ContextManagedStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        this.validateStatementForContext(statement, streamAnalysis);
        ContextManagerPartitionedStatementDesc desc = new ContextManagerPartitionedStatementDesc(statement, streamAnalysis.getFilters());
        this.statements.put(statement.getStatementContext().getStatementId(), desc);
        for (Map.Entry<ContextDetailCategoryItem, Integer> entry : this.instances.entrySet()) {
            ContextDetailCategoryItem category = entry.getKey();
            Integer agentInstanceId = entry.getValue();
            StatementAgentInstanceFactoryResult result = ContextManagerCategorized.startContextStatement(this.contextDescriptor, this.contextName, this.servicesContext, category, desc, agentInstanceId, this.categorySpec);
            AgentInstance agentInstance = new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
            desc.getInstances().add(agentInstance);
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
        if (this.statements.isEmpty()) {
            this.safeDestroy();
        }
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        ContextManagerPartitionedStatementDesc stmtDesc = this.statements.get(statementId);
        if (stmtDesc == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        AgentInstance[] instances = stmtDesc.getInstances().toArray(new AgentInstance[stmtDesc.getInstances().size()]);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        ContextManagerPartitionedStatementDesc stmtDesc = this.statements.get(statementId);
        if (stmtDesc == null) {
            return SafeIteratorNull.NULL_EVENT_ITER;
        }
        AgentInstance[] instances = stmtDesc.getInstances().toArray(new AgentInstance[stmtDesc.getInstances().size()]);
        return new AgentInstanceArraySafeIterator(instances);
    }

    private void removeStatement(String statementId) {
        ContextManagerPartitionedStatementDesc statementDesc = this.statements.get(statementId);
        if (statementDesc == null) {
            return;
        }
        for (AgentInstance instance : statementDesc.getInstances()) {
            StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext);
        }
        this.statements.remove(statementId);
    }

    private void validateStatementForContext(ContextManagedStatementBase statement, StatementSpecCompiledAnalyzerResult streamAnalysis) throws ExprValidationException {
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean isCreateWindow = statement.getStatementSpec().getCreateWindowDesc() != null;
        String message = "Category context requires that any of the events types that are listed in the category context also appear in any of the filter expressions of the statement";
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                EventType contextType;
                EventType stmtFilterType = filter.getFilterForEventType();
                if (stmtFilterType == (contextType = this.categorySpec.getFilterSpecCompiled().getFilterForEventType())) {
                    return;
                }
                if (!EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, contextType)) continue;
                return;
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(message);
            }
            return;
        }
        String declaredAsName = statement.getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            if (this.categorySpec.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) {
                return;
            }
            throw new ExprValidationException(message);
        }
    }

    private static StatementAgentInstanceFactoryResult startContextStatement(ContextDescriptor contextDescriptor, String contextName, EPServicesContext servicesContext, ContextDetailCategoryItem category, ContextManagerPartitionedStatementDesc statementDesc, int agentInstanceId, ContextDetailCategory categorySpec) {
        AgentInstanceFilterProxyImpl filterProxy = ContextManagerCategorized.getAddendumFilters(category, categorySpec, statementDesc);
        EventBean context = ContextPropertyEventType.getCategorizedBean(servicesContext.getEventAdapterService(), contextDescriptor.getContextPropertyRegistry().getContextEventType(), contextName, agentInstanceId, category.getName());
        return StatementAgentInstanceUtil.start(servicesContext, statementDesc.getStatement(), false, agentInstanceId, context, filterProxy);
    }

    private static AgentInstanceFilterProxyImpl getAddendumFilters(ContextDetailCategoryItem category, ContextDetailCategory categorySpec, ContextManagerPartitionedStatementDesc statementDesc) {
        IdentityHashMap<FilterSpecCompiled, List<FilterValueSetParam>> addendums;
        block3: {
            block2: {
                boolean isCreateWindow;
                addendums = new IdentityHashMap<FilterSpecCompiled, List<FilterValueSetParam>>();
                boolean bl = isCreateWindow = statementDesc.getStatement().getStatementSpec().getCreateWindowDesc() != null;
                if (isCreateWindow) break block2;
                for (FilterSpecCompiled filtersSpec : statementDesc.getFiltersSpecs()) {
                    boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), categorySpec.getFilterSpecCompiled().getFilterForEventType());
                    if (!typeOrSubtype) continue;
                    ArrayList<FilterValueSetParam> addendumFilters = new ArrayList<FilterValueSetParam>();
                    addendumFilters.addAll(category.getCompiledFilterParam());
                    addendumFilters.addAll(categorySpec.getFilterParamsCompiled());
                    addendums.put(filtersSpec, addendumFilters);
                }
                break block3;
            }
            String declaredAsName = statementDesc.getStatement().getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) break block3;
            for (FilterSpecCompiled filtersSpec : statementDesc.getFiltersSpecs()) {
                ArrayList<FilterValueSetParam> addendumFilters = new ArrayList<FilterValueSetParam>();
                addendumFilters.addAll(category.getCompiledFilterParam());
                addendumFilters.addAll(categorySpec.getFilterParamsCompiled());
                addendums.put(filtersSpec, addendumFilters);
            }
        }
        return new AgentInstanceFilterProxyImpl(addendums);
    }

    private void validateContextDesc(ContextDetailCategory categorySpec) throws ExprValidationException {
        if (categorySpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
    }
}

