/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.SafeIteratorNull;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceArraySafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyImpl;
import com.espertech.esper.core.context.mgr.ContextManagedStatementBase;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextManagerPartitionedFilterCallback;
import com.espertech.esper.core.context.mgr.ContextManagerPartitionedInstanceCreateCallback;
import com.espertech.esper.core.context.mgr.ContextManagerPartitionedStatementDesc;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.mgr.ContextState;
import com.espertech.esper.core.context.mgr.ContextStateService;
import com.espertech.esper.core.context.mgr.ContextStateServiceBinding;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.FilterValueSetParamImpl;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ContextManagerPartitioned
implements ContextManager,
ContextManagerPartitionedInstanceCreateCallback,
ContextIteratorHandler {
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final ContextDetailPartitioned segmentedSpec;
    private final AgentInstanceContext agentInstanceContextCreateContext;
    private final ContextStateService stateService;
    private final ContextStateServiceBinding stateServiceBinding;
    private final ContextDescriptor contextDescriptor;
    private final Map<Object, Integer> partitionKeys = new LinkedHashMap<Object, Integer>();
    private final Map<String, ContextManagerPartitionedStatementDesc> statements = new LinkedHashMap<String, ContextManagerPartitionedStatementDesc>();
    private final List<ContextManagerPartitionedFilterCallback> filterCallbacks = new ArrayList<ContextManagerPartitionedFilterCallback>();
    private int numInstances;

    public ContextManagerPartitioned(String contextName, EPServicesContext servicesContext, ContextDetailPartitioned segmentedSpec, AgentInstanceContext agentInstanceContextCreateContext, ContextStateService stateService) throws ExprValidationException {
        this.contextName = contextName;
        this.servicesContext = servicesContext;
        this.segmentedSpec = segmentedSpec;
        this.agentInstanceContextCreateContext = agentInstanceContextCreateContext;
        this.stateService = stateService;
        Class[] propertyTypes = this.validateContextDesc(segmentedSpec);
        StatementAIResourceRegistryFactory resourceRegistryFactory = new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
        EventType contextPropsType = ContextPropertyEventType.getPartitionType(contextName, segmentedSpec, propertyTypes, servicesContext.getEventAdapterService());
        ContextPropertyRegistryImpl registry = new ContextPropertyRegistryImpl(segmentedSpec.getItems(), contextPropsType);
        this.contextDescriptor = new ContextDescriptor(contextName, false, registry, resourceRegistryFactory, this);
        this.stateServiceBinding = stateService.getBinding(propertyTypes);
        int lastInstanceId = -1;
        List<ContextState> contextStates = stateService.getContexts(contextName, this.stateServiceBinding, servicesContext.getEventAdapterService());
        for (ContextState state : contextStates) {
            int instanceId = state.getAgentInstanceId();
            if (lastInstanceId < instanceId) {
                lastInstanceId = instanceId;
            }
            this.partitionKeys.put(state.getAdditionalInfo(), instanceId);
        }
        this.numInstances = lastInstanceId;
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public synchronized void safeDestroy() {
        this.deactivate();
    }

    @Override
    public synchronized void addStatement(ContextManagedStatementBase statement) throws ExprValidationException {
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(statement.getStatementSpec());
        this.validateStatementForContext(statement, streamAnalysis);
        if (this.statements.isEmpty()) {
            this.activate();
        }
        ContextManagerPartitionedStatementDesc desc = new ContextManagerPartitionedStatementDesc(statement, streamAnalysis.getFilters());
        this.statements.put(statement.getStatementContext().getStatementId(), desc);
        for (Map.Entry<Object, Integer> entry : this.partitionKeys.entrySet()) {
            Object key = entry.getKey();
            Integer agentInstanceId = entry.getValue();
            StatementAgentInstanceFactoryResult result = ContextManagerPartitioned.startContextStatement(this.contextDescriptor.getContextPropertyRegistry().getContextEventType(), this.contextName, this.servicesContext, key, desc, agentInstanceId, this.segmentedSpec);
            AgentInstance instance = new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
            desc.getInstances().add(instance);
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
        if (this.statements.isEmpty()) {
            this.safeDestroy();
        }
    }

    @Override
    public void create(Object keyValue, EventBean event) {
        Integer agentInstanceId = this.partitionKeys.get(keyValue);
        if (agentInstanceId != null) {
            return;
        }
        this.handleNewKey(keyValue, event);
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        ContextManagerPartitionedStatementDesc stmtDesc = this.statements.get(statementId);
        if (stmtDesc == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        AgentInstance[] instances = stmtDesc.getInstances().toArray(new AgentInstance[stmtDesc.getInstances().size()]);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        ContextManagerPartitionedStatementDesc stmtDesc = this.statements.get(statementId);
        if (stmtDesc == null) {
            return SafeIteratorNull.NULL_EVENT_ITER;
        }
        AgentInstance[] instances = stmtDesc.getInstances().toArray(new AgentInstance[stmtDesc.getInstances().size()]);
        return new AgentInstanceArraySafeIterator(instances);
    }

    private synchronized void handleNewKey(Object keyValue, EventBean event) {
        int agentInstanceId = ++this.numInstances;
        ArrayList<AgentInstance> newInstances = new ArrayList<AgentInstance>();
        for (Map.Entry<String, ContextManagerPartitionedStatementDesc> entry : this.statements.entrySet()) {
            ContextManagerPartitionedStatementDesc statementDesc = entry.getValue();
            StatementAgentInstanceFactoryResult startResult = ContextManagerPartitioned.startContextStatement(this.contextDescriptor.getContextPropertyRegistry().getContextEventType(), this.contextName, this.servicesContext, keyValue, statementDesc, agentInstanceId, this.segmentedSpec);
            AgentInstance instance = new AgentInstance(startResult.getStopCallback(), startResult.getAgentInstanceContext(), startResult.getFinalView());
            statementDesc.getInstances().add(instance);
            newInstances.add(instance);
        }
        this.stateService.addContext(this.contextName, agentInstanceId, keyValue, this.stateServiceBinding);
        for (AgentInstance context : newInstances) {
            StatementAgentInstanceUtil.evaluateEventForStatement(this.servicesContext, this.agentInstanceContextCreateContext, event, context.getAgentInstanceContext());
        }
        this.partitionKeys.put(keyValue, agentInstanceId);
    }

    private static StatementAgentInstanceFactoryResult startContextStatement(EventType contextPropsType, String contextName, EPServicesContext servicesContext, Object keyValue, ContextManagerPartitionedStatementDesc statementDesc, int agentInstanceId, ContextDetailPartitioned segmentedSpec) {
        AgentInstanceFilterProxyImpl filterProxy = ContextManagerPartitioned.getAddendumFilters(keyValue, statementDesc.getFiltersSpecs(), segmentedSpec, statementDesc);
        List<String> propertyNames = segmentedSpec.getItems().get(0).getPropertyNames();
        Object[] agentInstanceProperties = propertyNames.size() == 1 ? new Object[]{keyValue} : ((MultiKeyUntyped)keyValue).getKeys();
        EventBean builtin = ContextPropertyEventType.getPartitionBean(servicesContext.getEventAdapterService(), contextPropsType, contextName, agentInstanceId, agentInstanceProperties);
        return StatementAgentInstanceUtil.start(servicesContext, statementDesc.getStatement(), false, agentInstanceId, builtin, filterProxy);
    }

    private static AgentInstanceFilterProxyImpl getAddendumFilters(Object keyValue, List<FilterSpecCompiled> filtersSpecs, ContextDetailPartitioned segmentedSpec, ContextManagerPartitionedStatementDesc statementDesc) {
        IdentityHashMap<FilterSpecCompiled, List<FilterValueSetParam>> addendums;
        block9: {
            block8: {
                boolean isCreateWindow;
                addendums = new IdentityHashMap<FilterSpecCompiled, List<FilterValueSetParam>>();
                boolean bl = isCreateWindow = statementDesc.getStatement().getStatementSpec().getCreateWindowDesc() != null;
                if (isCreateWindow) break block8;
                for (FilterSpecCompiled filtersSpec : filtersSpecs) {
                    ContextDetailPartitionItem foundPartition = null;
                    for (ContextDetailPartitionItem partitionItem : segmentedSpec.getItems()) {
                        boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filtersSpec.getFilterForEventType(), partitionItem.getFilterSpecCompiled().getFilterForEventType());
                        if (!typeOrSubtype) continue;
                        foundPartition = partitionItem;
                    }
                    if (foundPartition == null) continue;
                    ArrayList<FilterValueSetParam> addendumFilters = new ArrayList<FilterValueSetParam>(foundPartition.getPropertyNames().size());
                    if (foundPartition.getPropertyNames().size() == 1) {
                        FilterValueSetParamImpl filter = new FilterValueSetParamImpl(foundPartition.getPropertyNames().get(0), FilterOperator.EQUAL, keyValue);
                        addendumFilters.add(filter);
                    } else {
                        Object[] keys = ((MultiKeyUntyped)keyValue).getKeys();
                        for (int i = 0; i < foundPartition.getPropertyNames().size(); ++i) {
                            String partitionPropertyName = foundPartition.getPropertyNames().get(i);
                            FilterValueSetParamImpl filter = new FilterValueSetParamImpl(partitionPropertyName, FilterOperator.EQUAL, keys[i]);
                            addendumFilters.add(filter);
                        }
                    }
                    addendumFilters.addAll(foundPartition.getParametersCompiled());
                    addendums.put(filtersSpec, addendumFilters);
                }
                break block9;
            }
            String declaredAsName = statementDesc.getStatement().getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
            if (declaredAsName == null) break block9;
            for (FilterSpecCompiled filtersSpec : filtersSpecs) {
                ContextDetailPartitionItem foundPartition = null;
                for (ContextDetailPartitionItem partitionItem : segmentedSpec.getItems()) {
                    if (!partitionItem.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) continue;
                    foundPartition = partitionItem;
                    break;
                }
                if (foundPartition == null) continue;
                ArrayList<FilterValueSetParamImpl> addendumFilters = new ArrayList<FilterValueSetParamImpl>(foundPartition.getPropertyNames().size());
                for (String partitionPropertyName : foundPartition.getPropertyNames()) {
                    FilterValueSetParamImpl filter = new FilterValueSetParamImpl(partitionPropertyName, FilterOperator.EQUAL, keyValue);
                    addendumFilters.add(filter);
                }
                addendums.put(filtersSpec, addendumFilters);
            }
        }
        return new AgentInstanceFilterProxyImpl(addendums);
    }

    private void activate() {
        for (ContextDetailPartitionItem item : this.segmentedSpec.getItems()) {
            ContextManagerPartitionedFilterCallback callback = new ContextManagerPartitionedFilterCallback(this.servicesContext, this.agentInstanceContextCreateContext, item, this);
            this.filterCallbacks.add(callback);
        }
    }

    private void deactivate() {
        for (ContextManagerPartitionedFilterCallback callback : this.filterCallbacks) {
            callback.destroy(this.servicesContext.getFilterService());
        }
        this.statements.clear();
        this.partitionKeys.clear();
        this.filterCallbacks.clear();
    }

    private Class[] validateContextDesc(ContextDetailPartitioned segmentedSpec) throws ExprValidationException {
        if (segmentedSpec.getItems().isEmpty()) {
            throw new ExprValidationException("Empty list of partition items");
        }
        for (ContextDetailPartitionItem item : segmentedSpec.getItems()) {
            EventType type = item.getFilterSpecCompiled().getFilterForEventType();
            for (String property : item.getPropertyNames()) {
                EventPropertyGetter getter = type.getGetter(property);
                if (getter != null) continue;
                throw new ExprValidationException("Property name '" + property + "' not found on type " + type.getName());
            }
        }
        ContextDetailPartitionItem firstItem = segmentedSpec.getItems().get(0);
        if (segmentedSpec.getItems().size() > 1) {
            for (int i = 0; i < segmentedSpec.getItems().size(); ++i) {
                EventType compareTo = segmentedSpec.getItems().get(i).getFilterSpecCompiled().getFilterForEventType();
                for (int j = 0; j < segmentedSpec.getItems().size(); ++j) {
                    if (i == j) continue;
                    EventType compareFrom = segmentedSpec.getItems().get(j).getFilterSpecCompiled().getFilterForEventType();
                    if (compareFrom == compareTo) {
                        throw new ExprValidationException("The event type '" + compareFrom.getName() + "' is listed twice");
                    }
                    if (!EventTypeUtility.isTypeOrSubTypeOf(compareFrom, compareTo) && !EventTypeUtility.isTypeOrSubTypeOf(compareTo, compareFrom)) continue;
                    throw new ExprValidationException("The event type '" + compareFrom.getName() + "' is listed twice: Event type '" + compareFrom.getName() + "' is a subtype or supertype of event type '" + compareTo.getName() + "'");
                }
            }
            String[] names = new String[firstItem.getPropertyNames().size()];
            Class[] types = new Class[firstItem.getPropertyNames().size()];
            Class[] typesBoxed = new Class[firstItem.getPropertyNames().size()];
            for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
                String property;
                names[i] = property = firstItem.getPropertyNames().get(i);
                types[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
                typesBoxed[i] = JavaClassHelper.getBoxedType(types[i]);
            }
            for (int item = 1; item < segmentedSpec.getItems().size(); ++item) {
                ContextDetailPartitionItem nextItem = segmentedSpec.getItems().get(item);
                if (nextItem.getPropertyNames().size() != types.length) {
                    throw new ExprValidationException("Expected the same number of property names for each event type, found " + types.length + " properties for event type '" + firstItem.getFilterSpecCompiled().getFilterForEventType().getName() + "' and " + nextItem.getPropertyNames().size() + " properties for event type '" + nextItem.getFilterSpecCompiled().getFilterForEventType().getName() + "'");
                }
                for (int i = 0; i < nextItem.getPropertyNames().size(); ++i) {
                    String property = nextItem.getPropertyNames().get(i);
                    Class type = JavaClassHelper.getBoxedType(nextItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property));
                    Class typeBoxed = JavaClassHelper.getBoxedType(type);
                    boolean left = JavaClassHelper.isSubclassOrImplementsInterface(typeBoxed, typesBoxed[i]);
                    boolean right = JavaClassHelper.isSubclassOrImplementsInterface(typesBoxed[i], typeBoxed);
                    if (typeBoxed == typesBoxed[i] || left || right) continue;
                    throw new ExprValidationException("Found mismatch of property types, property '" + names[i] + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(types[i]) + "' compared to property '" + property + "' of type '" + JavaClassHelper.getClassNameFullyQualPretty(typeBoxed) + "'");
                }
            }
        }
        Class[] propertyTypes = new Class[firstItem.getPropertyNames().size()];
        for (int i = 0; i < firstItem.getPropertyNames().size(); ++i) {
            String property = firstItem.getPropertyNames().get(i);
            propertyTypes[i] = firstItem.getFilterSpecCompiled().getFilterForEventType().getPropertyType(property);
        }
        return propertyTypes;
    }

    private void validateStatementForContext(ContextManagedStatementBase statement, StatementSpecCompiledAnalyzerResult streamAnalysis) throws ExprValidationException {
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean isCreateWindow = statement.getStatementSpec().getCreateWindowDesc() != null;
        String message = "Segmented context requires that any of the events types that are listed in the segmented context also appear in any of the filter expressions of the statement";
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                for (ContextDetailPartitionItem item : this.segmentedSpec.getItems()) {
                    EventType contextType;
                    EventType stmtFilterType = filter.getFilterForEventType();
                    if (stmtFilterType == (contextType = item.getFilterSpecCompiled().getFilterForEventType())) {
                        return;
                    }
                    if (!EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, contextType)) continue;
                    return;
                }
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(message);
            }
            return;
        }
        String declaredAsName = statement.getStatementSpec().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            for (ContextDetailPartitionItem item : this.segmentedSpec.getItems()) {
                if (!item.getFilterSpecCompiled().getFilterForEventType().getName().equals(declaredAsName)) continue;
                return;
            }
            throw new ExprValidationException(message);
        }
    }

    private void removeStatement(String statementId) {
        ContextManagerPartitionedStatementDesc statementDesc = this.statements.get(statementId);
        if (statementDesc == null) {
            return;
        }
        for (AgentInstance instance : statementDesc.getInstances()) {
            StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext);
        }
        this.statements.remove(statementId);
    }
}

