/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.ContextManagerPartitionedInstanceCreateCallback;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterValueSet;
import java.util.Collection;

public class ContextManagerPartitionedFilterCallback
implements FilterHandleCallback {
    private final AgentInstanceContext agentInstanceContextCreateContext;
    private final EventPropertyGetter[] getters;
    private final ContextManagerPartitionedInstanceCreateCallback callback;
    private final EPStatementHandleCallback filterHandle;

    public ContextManagerPartitionedFilterCallback(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContextCreateContext, ContextDetailPartitionItem partitionItem, ContextManagerPartitionedInstanceCreateCallback callback) {
        this.agentInstanceContextCreateContext = agentInstanceContextCreateContext;
        this.callback = callback;
        this.filterHandle = new EPStatementHandleCallback(agentInstanceContextCreateContext.getEpStatementAgentInstanceHandle(), this);
        this.getters = new EventPropertyGetter[partitionItem.getPropertyNames().size()];
        for (int i = 0; i < partitionItem.getPropertyNames().size(); ++i) {
            EventPropertyGetter getter;
            String propertyName = partitionItem.getPropertyNames().get(i);
            this.getters[i] = getter = partitionItem.getFilterSpecCompiled().getFilterForEventType().getGetter(propertyName);
        }
        FilterValueSet filterValueSet = partitionItem.getFilterSpecCompiled().getValueSet(null, null, null);
        servicesContext.getFilterService().add(filterValueSet, this.filterHandle);
    }

    @Override
    public void matchFound(EventBean event, Collection<FilterHandleCallback> allStmtMatches) {
        Object key;
        if (this.getters.length > 1) {
            Object[] keys = new Object[this.getters.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.getters[i].get(event);
            }
            key = new MultiKeyUntyped(keys);
        } else {
            key = this.getters[0].get(event);
        }
        this.callback.create(key, event);
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    @Override
    public String getStatementId() {
        return this.agentInstanceContextCreateContext.getStatementContext().getStatementId();
    }

    public void destroy(FilterService filterService) {
        filterService.remove(this.filterHandle);
    }
}

