/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.collection.SafeIteratorNull;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceArraySafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyNull;
import com.espertech.esper.core.context.mgr.ContextManagedStatementBase;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.mgr.ContextState;
import com.espertech.esper.core.context.mgr.ContextStateService;
import com.espertech.esper.core.context.mgr.ContextStateServiceBinding;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternMatchCallback;
import com.espertech.esper.pattern.PatternStopCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextManagerTemporalOverlap
implements ContextManager,
PatternMatchCallback,
ContextIteratorHandler {
    private static final Log log = LogFactory.getLog(ContextManagerTemporalOverlap.class);
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final AgentInstanceContext createContextContext;
    private final ContextDetailInitiatedTerminated overlapSpec;
    private final ContextStateService contextStateService;
    private final ContextStateServiceBinding contextStateServiceBinding;
    private final ContextDescriptor contextDescriptor;
    private final Map<String, Set<AgentInstance>> statementInstances = new HashMap<String, Set<AgentInstance>>();
    private final Map<String, ContextManagedStatementBase> statements = new LinkedHashMap<String, ContextManagedStatementBase>();
    private final TreeMap<Integer, ContextPlusSchedule> agentInstances = new TreeMap();
    private PatternStopCallback patternStopCallback;
    private EPStatementHandleCallback filterHandle;

    public ContextManagerTemporalOverlap(String contextName, EPServicesContext servicesContext, AgentInstanceContext createContextContext, ContextDetailInitiatedTerminated overlapSpec, ContextStateService contextStateService) {
        this.contextName = contextName;
        this.servicesContext = servicesContext;
        this.createContextContext = createContextContext;
        this.overlapSpec = overlapSpec;
        this.contextStateService = contextStateService;
        StatementAIResourceRegistryFactory resourceRegistryFactory = new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
            }
        };
        EventType eventTypeContextProps = ContextPropertyEventType.getTemporalOverlapType(contextName, overlapSpec, servicesContext.getEventAdapterService());
        ContextPropertyRegistryImpl contextProperties = new ContextPropertyRegistryImpl(eventTypeContextProps);
        this.contextDescriptor = new ContextDescriptor(contextName, false, contextProperties, resourceRegistryFactory, this);
        this.contextStateServiceBinding = contextStateService.getBinding(eventTypeContextProps);
        List<ContextState> contextStates = contextStateService.getContexts(contextName, this.contextStateServiceBinding, servicesContext.getEventAdapterService());
        for (ContextState contextState : contextStates) {
            int instanceId = contextState.getAgentInstanceId();
            ContextPlusSchedule context = (ContextPlusSchedule)contextState.getAdditionalInfo();
            this.agentInstances.put(instanceId, context);
        }
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        Set<AgentInstance> list = this.statementInstances.get(statementId);
        if (list == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        AgentInstance[] instances = list.toArray(new AgentInstance[list.size()]);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        Set<AgentInstance> list = this.statementInstances.get(statementId);
        if (list == null) {
            return SafeIteratorNull.NULL_EVENT_ITER;
        }
        AgentInstance[] instances = list.toArray(new AgentInstance[list.size()]);
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public synchronized void addStatement(ContextManagedStatementBase statement) throws ExprValidationException {
        if (this.statements.isEmpty()) {
            this.activate();
        }
        this.statements.put(statement.getStatementContext().getStatementId(), statement);
        LinkedHashSet<AgentInstance> instanceList = new LinkedHashSet<AgentInstance>();
        this.statementInstances.put(statement.getStatementContext().getStatementId(), instanceList);
        for (Map.Entry<Integer, ContextPlusSchedule> entry : this.agentInstances.entrySet()) {
            Integer agentInstanceId = entry.getKey();
            ContextPlusSchedule scheduleAndContext = entry.getValue();
            AgentInstance result = this.startAgentInstance(statement, agentInstanceId, scheduleAndContext.getContextEvent());
            instanceList.add(result);
            if (scheduleAndContext.getContextScheduleCallbackHandle() != null) continue;
            ScheduleSlot scheduleSlot = this.createContextContext.getStatementContext().getScheduleBucket().allocateSlot();
            long timeOffset = this.servicesContext.getSchedulingService().getTime() - scheduleAndContext.getStartTime();
            EPStatementHandleCallback callback = this.scheduleCallback(agentInstanceId, scheduleSlot, timeOffset);
            scheduleAndContext.setContextScheduleCallbackHandle(callback, scheduleSlot);
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
        if (this.statements.isEmpty()) {
            this.safeDestroy();
        }
    }

    @Override
    public synchronized void safeDestroy() {
        this.deactivate();
    }

    @Override
    public synchronized void matchFound(Map<String, Object> matchEvent) {
        this.processMatchFound(matchEvent, null);
    }

    private void activate() {
        if (this.overlapSpec.getInitiatedPattern() != null) {
            if (this.patternStopCallback != null) {
                this.patternStopCallback.stop();
            }
            PatternContext patternContext = new PatternContext(this.createContextContext.getStatementContext(), 0);
            EvalRootFactoryNode rootFactoryNode = this.servicesContext.getPatternNodeFactory().makeRootNode();
            rootFactoryNode.addChildNode(this.overlapSpec.getInitiatedPatternCompiled().getEvalFactoryNode());
            PatternAgentInstanceContext patternAgentInstanceContext = this.createContextContext.getStatementContext().getPatternContextFactory().createPatternAgentContext(patternContext, this.createContextContext, false);
            EvalRootNode rootNode = EvalNodeUtil.makeRootNodeFromFactory(rootFactoryNode, patternAgentInstanceContext);
            this.patternStopCallback = rootNode.start(this, patternContext);
        } else {
            FilterHandleCallback filterCallback = new FilterHandleCallback(){

                @Override
                public String getStatementId() {
                    return ContextManagerTemporalOverlap.this.createContextContext.getStatementContext().getStatementId();
                }

                @Override
                public void matchFound(EventBean event, Collection<FilterHandleCallback> allStmtMatches) {
                    ContextManagerTemporalOverlap.this.filterMatchFound(event);
                }

                @Override
                public boolean isSubSelect() {
                    return false;
                }
            };
            this.filterHandle = new EPStatementHandleCallback(this.createContextContext.getEpStatementAgentInstanceHandle(), filterCallback);
            FilterValueSet filterValueSet = this.overlapSpec.getInitiatedFilterCompiled().getValueSet(null, null, null);
            this.servicesContext.getFilterService().add(filterValueSet, this.filterHandle);
        }
    }

    private void filterMatchFound(EventBean event) {
        this.processMatchFound(null, event);
    }

    private void processMatchFound(Map<String, Object> patternData, EventBean filterEvent) {
        if (this.statements.isEmpty()) {
            return;
        }
        int agentInstanceId = ContextManagerTemporalOverlap.nextId(this.agentInstances);
        EventBean context = ContextPropertyEventType.getTempOverlapBean(this.servicesContext.getEventAdapterService(), this.contextDescriptor.getContextPropertyRegistry().getContextEventType(), this.contextName, agentInstanceId, patternData, filterEvent, this.overlapSpec.getInitiatedFilterAsName());
        ContextPlusSchedule scheduleAndContext = new ContextPlusSchedule(context, this.servicesContext.getSchedulingService().getTime());
        this.agentInstances.put(agentInstanceId, scheduleAndContext);
        this.contextStateService.addContext(this.contextName, agentInstanceId, scheduleAndContext, this.contextStateServiceBinding);
        ScheduleSlot scheduleSlot = this.createContextContext.getStatementContext().getScheduleBucket().allocateSlot();
        EPStatementHandleCallback scheduleHandle = this.scheduleCallback(agentInstanceId, scheduleSlot, 0L);
        scheduleAndContext.setContextScheduleCallbackHandle(scheduleHandle, scheduleSlot);
        for (ContextManagedStatementBase statement : this.statements.values()) {
            Set<AgentInstance> instanceList = this.statementInstances.get(statement.getStatementContext().getStatementId());
            if (instanceList == null) {
                instanceList = new LinkedHashSet<AgentInstance>();
                this.statementInstances.put(statement.getStatementContext().getStatementId(), instanceList);
            }
            AgentInstance ai = this.startAgentInstance(statement, agentInstanceId, context);
            if (filterEvent != null) {
                StatementAgentInstanceUtil.evaluateEventForStatement(this.servicesContext, this.createContextContext, filterEvent, ai.getAgentInstanceContext());
            }
            instanceList.add(ai);
        }
    }

    private AgentInstance startAgentInstance(ContextManagedStatementBase statement, int agentInstanceId, EventBean contextBean) {
        StatementAgentInstanceFactoryResult result = StatementAgentInstanceUtil.start(this.servicesContext, statement, false, agentInstanceId, contextBean, AgentInstanceFilterProxyNull.AGENT_INSTANCE_FILTER_PROXY_NULL);
        return new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
    }

    private void deactivate() {
        if (this.patternStopCallback != null) {
            this.patternStopCallback.stop();
            this.patternStopCallback = null;
        }
        if (this.filterHandle != null) {
            this.servicesContext.getFilterService().remove(this.filterHandle);
            this.filterHandle = null;
        }
        for (Map.Entry<Integer, ContextPlusSchedule> entry : this.agentInstances.entrySet()) {
            if (entry.getValue().getContextScheduleCallbackHandle() == null) continue;
            this.servicesContext.getSchedulingService().remove(entry.getValue().getContextScheduleCallbackHandle(), entry.getValue().getScheduleSlot());
        }
        this.agentInstances.clear();
    }

    private void removeStatement(String statementId) {
        Set<AgentInstance> instanceList = this.statementInstances.get(statementId);
        if (instanceList != null) {
            for (AgentInstance entry : instanceList) {
                StatementAgentInstanceUtil.stop(entry.getStopCallback(), entry.getAgentInstanceContext(), entry.getFinalView(), this.servicesContext);
            }
        }
        this.statementInstances.remove(statementId);
        this.statements.remove(statementId);
        if (this.statements.isEmpty()) {
            this.agentInstances.clear();
        }
    }

    private static int nextId(TreeMap<Integer, ContextPlusSchedule> instanceIds) {
        if (instanceIds.isEmpty()) {
            return 0;
        }
        if (instanceIds.lastKey() == instanceIds.size() - 1) {
            return instanceIds.lastKey() + 1;
        }
        for (int i = 0; i < instanceIds.size(); ++i) {
            if (instanceIds.containsKey(i)) continue;
            return i;
        }
        return instanceIds.lastKey() + 1;
    }

    private EPStatementHandleCallback scheduleCallback(final int agentInstanceId, ScheduleSlot scheduleSlot, long timeOffset) {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                ContextManagerTemporalOverlap.this.stopAgentInstanceCallback(agentInstanceId);
            }
        };
        EPStatementAgentInstanceHandle agentHandle = new EPStatementAgentInstanceHandle(this.createContextContext.getStatementContext().getEpStatementHandle(), this.createContextContext.getStatementContext().getDefaultAgentInstanceLock(), null, new StatementAgentInstanceFilterVersion());
        EPStatementHandleCallback contextScheduleCallbackHandle = new EPStatementHandleCallback(agentHandle, callback);
        Double interval = (Double)this.overlapSpec.getTerminatedTimePeriod().evaluate(null, true, this.createContextContext);
        if (interval == null) {
            log.warn((Object)("Time period expression in context '" + this.contextName + "' returned a null value, not scheduling time period"));
        } else {
            long msec = (long)(interval * 1000.0) - timeOffset;
            this.servicesContext.getSchedulingService().add(msec, (ScheduleHandle)contextScheduleCallbackHandle, scheduleSlot);
        }
        return contextScheduleCallbackHandle;
    }

    private void stopAgentInstanceCallback(int agentInstanceId) {
        for (Map.Entry<String, Set<AgentInstance>> entry : this.statementInstances.entrySet()) {
            Iterator<AgentInstance> agentInstanceIterator = entry.getValue().iterator();
            while (agentInstanceIterator.hasNext()) {
                AgentInstance agentInstance = agentInstanceIterator.next();
                if (agentInstance.getAgentInstanceContext().getAgentInstanceIds()[0] != agentInstanceId) continue;
                agentInstanceIterator.remove();
                StatementAgentInstanceUtil.stop(agentInstance.getStopCallback(), agentInstance.getAgentInstanceContext(), agentInstance.getFinalView(), this.servicesContext);
            }
        }
        this.agentInstances.remove(agentInstanceId);
        this.contextStateService.removeContextAgentInstance(this.contextName, agentInstanceId);
    }

    public static class ContextPlusSchedule {
        private final EventBean contextEvent;
        private final long startTime;
        private EPStatementHandleCallback contextScheduleCallbackHandle;
        private ScheduleSlot scheduleSlot;

        public ContextPlusSchedule(EventBean contextEvent, long startTime) {
            this.contextEvent = contextEvent;
            this.startTime = startTime;
        }

        public EventBean getContextEvent() {
            return this.contextEvent;
        }

        public EPStatementHandleCallback getContextScheduleCallbackHandle() {
            return this.contextScheduleCallbackHandle;
        }

        public void setContextScheduleCallbackHandle(EPStatementHandleCallback contextScheduleCallbackHandle, ScheduleSlot scheduleSlot) {
            this.contextScheduleCallbackHandle = contextScheduleCallbackHandle;
            this.scheduleSlot = scheduleSlot;
        }

        public ScheduleSlot getScheduleSlot() {
            return this.scheduleSlot;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

