/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.collection.SafeIteratorImpl;
import com.espertech.esper.collection.SafeIteratorNull;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxyNull;
import com.espertech.esper.core.context.mgr.ContextManagedStatementBase;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationSingle;
import com.espertech.esper.core.context.stmt.AIRegistryExprSingle;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.context.util.ContextIteratorHandler;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.util.CollectionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ContextManagerTemporalSingle
implements ContextManager,
ContextIteratorHandler {
    private final String contextName;
    private final EPServicesContext servicesContext;
    private final StatementContext createContextStmtContext;
    private final ScheduleSpec scheduleStart;
    private final ScheduleSpec scheduleEnd;
    private final ScheduleSlot scheduleSlot;
    private final ContextDescriptor contextDescriptor;
    private final Map<String, ContextManagedStatementBase> statements = new LinkedHashMap<String, ContextManagedStatementBase>();
    private final Map<String, AgentInstance> instances = new LinkedHashMap<String, AgentInstance>();
    private EPStatementHandleCallback contextScheduleCallbackHandle;
    private boolean statementsRunning;
    private long startTime;
    private long endTime;

    public ContextManagerTemporalSingle(String contextName, EPServicesContext servicesContext, StatementContext createContextStmtContext, ScheduleSpec scheduleStart, ScheduleSpec scheduleEnd) {
        this.contextName = contextName;
        this.servicesContext = servicesContext;
        this.createContextStmtContext = createContextStmtContext;
        this.scheduleStart = scheduleStart;
        this.scheduleEnd = scheduleEnd;
        this.scheduleSlot = createContextStmtContext.getScheduleBucket().allocateSlot();
        StatementAIResourceRegistryFactory resourceRegistryFactory = new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationSingle(), new AIRegistryExprSingle());
            }
        };
        EventType contextEventType = ContextPropertyEventType.getTemporalFixedType(contextName, servicesContext.getEventAdapterService());
        ContextPropertyRegistryImpl contextPropertyRegistry = new ContextPropertyRegistryImpl(contextEventType);
        this.contextDescriptor = new ContextDescriptor(contextName, true, contextPropertyRegistry, resourceRegistryFactory, this);
    }

    @Override
    public void safeDestroy() {
        this.endContextCallbacks();
        this.statements.clear();
        this.instances.clear();
    }

    @Override
    public ContextDescriptor getContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public synchronized Iterator<EventBean> iterator(String statementId) {
        AgentInstance agentInstance = this.instances.get(statementId);
        if (agentInstance == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        return agentInstance.getFinalView().iterator();
    }

    @Override
    public synchronized SafeIterator<EventBean> safeIterator(String statementId) {
        AgentInstance agentInstance = this.instances.get(statementId);
        if (agentInstance == null) {
            return SafeIteratorNull.NULL_EVENT_ITER;
        }
        StatementAgentInstanceLock theLock = agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        theLock.acquireReadLock();
        try {
            return new SafeIteratorImpl<EventBean>(theLock, agentInstance.getFinalView().iterator());
        }
        catch (RuntimeException ex) {
            theLock.releaseReadLock();
            throw ex;
        }
    }

    @Override
    public synchronized void addStatement(ContextManagedStatementBase statement) {
        if (this.statements.isEmpty()) {
            this.startContextCallbacks();
        }
        this.statements.put(statement.getStatementContext().getStatementId(), statement);
        if (this.isStatementsRunning()) {
            this.startStatement(statement);
        }
    }

    @Override
    public synchronized void stopStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
    }

    @Override
    public synchronized void destroyStatement(String statementName, String statementId) {
        this.removeStatement(statementId);
        if (this.statements.isEmpty()) {
            this.safeDestroy();
        }
    }

    private void removeStatement(String statementId) {
        AgentInstance instance = this.instances.get(statementId);
        if (instance != null) {
            StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext);
        }
        this.instances.remove(statementId);
        this.statements.remove(statementId);
    }

    protected void startStatement(ContextManagedStatementBase statement) {
        EventBean contextProperties = ContextPropertyEventType.getTemporalFixedBean(this.servicesContext.getEventAdapterService(), this.contextDescriptor.getContextPropertyRegistry().getContextEventType(), this.contextName, this.startTime, this.endTime);
        StatementAgentInstanceFactoryResult startResult = StatementAgentInstanceUtil.start(this.servicesContext, statement, true, 0, contextProperties, AgentInstanceFilterProxyNull.AGENT_INSTANCE_FILTER_PROXY_NULL);
        this.instances.put(statement.getStatementContext().getStatementId(), new AgentInstance(startResult.getStopCallback(), startResult.getAgentInstanceContext(), startResult.getFinalView()));
    }

    protected void activateStatements() {
        for (Map.Entry<String, ContextManagedStatementBase> stmtEntry : this.statements.entrySet()) {
            this.startStatement(stmtEntry.getValue());
        }
    }

    protected void deactivateStatements() {
        for (Map.Entry<String, AgentInstance> stmtEntry : this.instances.entrySet()) {
            AgentInstance instance = stmtEntry.getValue();
            StatementAgentInstanceUtil.stop(instance.getStopCallback(), instance.getAgentInstanceContext(), instance.getFinalView(), this.servicesContext);
        }
        this.instances.clear();
    }

    public boolean isStatementsRunning() {
        return this.statementsRunning;
    }

    private void startContextCallbacks() {
        long nextScheduledEndTime;
        long nextScheduledStartTime = ScheduleComputeHelper.computeNextOccurance(this.scheduleStart, this.createContextStmtContext.getTimeProvider().getTime());
        if (nextScheduledStartTime < (nextScheduledEndTime = ScheduleComputeHelper.computeNextOccurance(this.scheduleEnd, this.createContextStmtContext.getTimeProvider().getTime()))) {
            this.scheduleStart();
            this.statementsRunning = false;
            this.startTime = nextScheduledStartTime;
            this.endTime = nextScheduledEndTime;
        } else {
            this.scheduleEnd();
            this.statementsRunning = true;
            this.startTime = this.createContextStmtContext.getTimeProvider().getTime();
            this.endTime = nextScheduledEndTime;
        }
    }

    private void endContextCallbacks() {
        if (this.contextScheduleCallbackHandle != null) {
            this.servicesContext.getSchedulingService().remove(this.contextScheduleCallbackHandle, this.scheduleSlot);
        }
        this.contextScheduleCallbackHandle = null;
    }

    private EPStatementHandleCallback getCallbackHandle(ScheduleHandleCallback callback) {
        EPStatementAgentInstanceHandle agentHandle = new EPStatementAgentInstanceHandle(this.createContextStmtContext.getEpStatementHandle(), this.createContextStmtContext.getDefaultAgentInstanceLock(), null, new StatementAgentInstanceFilterVersion());
        this.contextScheduleCallbackHandle = new EPStatementHandleCallback(agentHandle, callback);
        return this.contextScheduleCallbackHandle;
    }

    private void scheduleStart() {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                ContextManagerTemporalSingle.this.activateStatements();
                ContextManagerTemporalSingle.this.scheduleEnd();
                ContextManagerTemporalSingle.this.statementsRunning = true;
            }
        };
        EPStatementHandleCallback handle = this.getCallbackHandle(callback);
        this.createContextStmtContext.getSchedulingService().add(this.scheduleStart, (ScheduleHandle)handle, this.scheduleSlot);
    }

    private void scheduleEnd() {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                ContextManagerTemporalSingle.this.deactivateStatements();
                ContextManagerTemporalSingle.this.scheduleStart();
                ContextManagerTemporalSingle.this.statementsRunning = false;
            }
        };
        this.contextScheduleCallbackHandle = this.getCallbackHandle(callback);
        this.createContextStmtContext.getSchedulingService().add(this.scheduleEnd, (ScheduleHandle)this.contextScheduleCallbackHandle, this.scheduleSlot);
    }
}

