/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.stmt;

import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.stmt.AIRegistryPrevious;
import com.espertech.esper.core.context.stmt.AIRegistryPrior;
import com.espertech.esper.core.context.stmt.AIRegistrySubselect;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import java.util.HashMap;
import java.util.Map;

public abstract class AIRegistryExprBase
implements AIRegistryExpr {
    private final Map<ExprSubselectNode, AIRegistrySubselect> subselects = new HashMap<ExprSubselectNode, AIRegistrySubselect>();
    private final Map<ExprPriorNode, AIRegistryPrior> priors = new HashMap<ExprPriorNode, AIRegistryPrior>();
    private final Map<ExprPreviousNode, AIRegistryPrevious> previous = new HashMap<ExprPreviousNode, AIRegistryPrevious>();

    public abstract AIRegistrySubselect allocateAIRegistrySubselect();

    public abstract AIRegistryPrevious allocateAIRegistryPrevious();

    public abstract AIRegistryPrior allocateAIRegistryPrior();

    @Override
    public AIRegistrySubselect getSubselectService(ExprSubselectNode exprSubselectNode) {
        return this.subselects.get(exprSubselectNode);
    }

    @Override
    public AIRegistryPrior getPriorServices(ExprPriorNode key) {
        return this.priors.get(key);
    }

    @Override
    public AIRegistryPrevious getPreviousServices(ExprPreviousNode key) {
        return this.previous.get(key);
    }

    @Override
    public AIRegistrySubselect allocateSubselect(ExprSubselectNode subselectNode) {
        AIRegistrySubselect subselect = this.allocateAIRegistrySubselect();
        this.subselects.put(subselectNode, subselect);
        return subselect;
    }

    @Override
    public AIRegistryPrior allocatePrior(ExprPriorNode key) {
        AIRegistryPrior service = this.allocateAIRegistryPrior();
        this.priors.put(key, service);
        return service;
    }

    @Override
    public AIRegistryPrevious allocatePrevious(ExprPreviousNode previousNode) {
        AIRegistryPrevious service = this.allocateAIRegistryPrevious();
        this.previous.put(previousNode, service);
        return service;
    }

    @Override
    public int getSubselectAgentInstanceCount() {
        int total = 0;
        for (Map.Entry<ExprSubselectNode, AIRegistrySubselect> entry : this.subselects.entrySet()) {
            total += entry.getValue().getAgentInstanceCount();
        }
        return total;
    }

    @Override
    public int getPreviousAgentInstanceCount() {
        int total = 0;
        for (Map.Entry<ExprPreviousNode, AIRegistryPrevious> entry : this.previous.entrySet()) {
            total += entry.getValue().getAgentInstanceCount();
        }
        return total;
    }

    @Override
    public int getPriorAgentInstanceCount() {
        int total = 0;
        for (Map.Entry<ExprPriorNode, AIRegistryPrior> entry : this.priors.entrySet()) {
            total += entry.getValue().getAgentInstanceCount();
        }
        return total;
    }

    @Override
    public void deassignService(int agentInstanceId) {
        for (Map.Entry<ExprSubselectNode, AIRegistrySubselect> entry : this.subselects.entrySet()) {
            entry.getValue().deassignService(agentInstanceId);
        }
        for (Map.Entry<ExprNodeBase, Object> entry : this.priors.entrySet()) {
            ((AIRegistryPrior)entry.getValue()).deassignService(agentInstanceId);
        }
        for (Map.Entry<ExprNodeBase, Object> entry : this.previous.entrySet()) {
            ((AIRegistryPrevious)entry.getValue()).deassignService(agentInstanceId);
        }
    }
}

