/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.ExpressionResultCacheService;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.core.start.EPStatementStartMethodHelperPrior;
import com.espertech.esper.epl.core.ViewResourceDelegateVerifiedStream;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class AgentInstanceViewFactoryChainContext
implements ExprEvaluatorContext {
    private final AgentInstanceContext agentInstanceContext;
    private boolean isRemoveStream;
    private final Object previousNodeGetter;
    private final ViewUpdatedCollection priorViewUpdatedCollection;

    public AgentInstanceViewFactoryChainContext(AgentInstanceContext agentInstanceContext, boolean isRemoveStream, Object previousNodeGetter, ViewUpdatedCollection priorViewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.isRemoveStream = isRemoveStream;
        this.previousNodeGetter = previousNodeGetter;
        this.priorViewUpdatedCollection = priorViewUpdatedCollection;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public boolean isRemoveStream() {
        return this.isRemoveStream;
    }

    public void setRemoveStream(boolean removeStream) {
        this.isRemoveStream = removeStream;
    }

    public Object getPreviousNodeGetter() {
        return this.previousNodeGetter;
    }

    public ViewUpdatedCollection getPriorViewUpdatedCollection() {
        return this.priorViewUpdatedCollection;
    }

    public StatementContext getStatementContext() {
        return this.agentInstanceContext.getStatementContext();
    }

    @Override
    public TimeProvider getTimeProvider() {
        return this.agentInstanceContext.getTimeProvider();
    }

    @Override
    public ExpressionResultCacheService getExpressionResultCacheService() {
        return this.agentInstanceContext.getExpressionResultCacheService();
    }

    @Override
    public int[] getAgentInstanceIds() {
        return this.agentInstanceContext.getAgentInstanceIds();
    }

    @Override
    public EventBean getContextProperties() {
        return this.agentInstanceContext.getContextProperties();
    }

    public EPStatementAgentInstanceHandle getEpStatementAgentInstanceHandle() {
        return this.agentInstanceContext.getEpStatementAgentInstanceHandle();
    }

    public Set<StopCallback> getTerminationCallbacks() {
        return this.agentInstanceContext.getTerminationCallbacks();
    }

    public static AgentInstanceViewFactoryChainContext create(List<ViewFactory> viewFactoryChain, AgentInstanceContext agentInstanceContext, ViewResourceDelegateVerifiedStream viewResourceDelegate) {
        Object previousNodeGetter = null;
        if (viewResourceDelegate.getPreviousRequests() != null && !viewResourceDelegate.getPreviousRequests().isEmpty()) {
            DataWindowViewWithPrevious factoryFound = EPStatementStartMethodHelperPrevious.findPreviousViewFactory(viewFactoryChain);
            previousNodeGetter = factoryFound.makePreviousGetter();
        }
        ViewUpdatedCollection priorViewUpdatedCollection = null;
        if (viewResourceDelegate.getPriorRequests() != null && !viewResourceDelegate.getPriorRequests().isEmpty()) {
            PriorEventViewFactory priorEventViewFactory = EPStatementStartMethodHelperPrior.findPriorViewFactory(viewFactoryChain);
            SortedMap<Integer, List<ExprPriorNode>> callbacksPerIndex = viewResourceDelegate.getPriorRequests();
            priorViewUpdatedCollection = priorEventViewFactory.makeViewUpdatedCollection(callbacksPerIndex, agentInstanceContext.getAgentInstanceIds());
        }
        boolean removedStream = false;
        if (viewFactoryChain.size() > 1) {
            int countDataWindow = 0;
            for (ViewFactory viewFactory : viewFactoryChain) {
                if (!(viewFactory instanceof DataWindowViewFactory)) continue;
                ++countDataWindow;
            }
            removedStream = countDataWindow > 1;
        }
        return new AgentInstanceViewFactoryChainContext(agentInstanceContext, removedStream, previousNodeGetter, priorViewUpdatedCollection);
    }
}

