/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.core.service.EPStatementDispatch;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;

public class EPStatementAgentInstanceHandle {
    private final EPStatementHandle statementHandle;
    private final String statementId;
    private transient StatementAgentInstanceLock statementAgentInstanceLock = null;
    private final int[] agentInstanceIds;
    private final int priority;
    private final boolean isPreemptive;
    private final boolean isHasVariables;
    private final boolean isCanSelfJoin;
    private final StatementAgentInstanceFilterVersion statementFilterVersion;
    private transient EPStatementDispatch optionalDispatchable;
    private boolean destroyed;
    private final int hashCode;

    public EPStatementAgentInstanceHandle(EPStatementHandle statementHandle, StatementAgentInstanceLock statementAgentInstanceLock, int[] agentInstanceIds, StatementAgentInstanceFilterVersion statementFilterVersion) {
        this.statementHandle = statementHandle;
        this.statementId = statementHandle.getStatementId();
        this.statementAgentInstanceLock = statementAgentInstanceLock;
        this.agentInstanceIds = agentInstanceIds;
        this.priority = statementHandle.getPriority();
        this.isPreemptive = statementHandle.isPreemptive();
        this.isHasVariables = statementHandle.isHasVariables();
        this.isCanSelfJoin = statementHandle.isCanSelfJoin();
        this.hashCode = statementHandle.hashCode();
        this.statementFilterVersion = statementFilterVersion;
    }

    public EPStatementHandle getStatementHandle() {
        return this.statementHandle;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public StatementAgentInstanceLock getStatementAgentInstanceLock() {
        return this.statementAgentInstanceLock;
    }

    public int[] getAgentInstanceIds() {
        return this.agentInstanceIds;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isPreemptive() {
        return this.isPreemptive;
    }

    public boolean isHasVariables() {
        return this.isHasVariables;
    }

    public boolean isCanSelfJoin() {
        return this.isCanSelfJoin;
    }

    public void setStatementAgentInstanceLock(StatementAgentInstanceLock statementAgentInstanceLock) {
        this.statementAgentInstanceLock = statementAgentInstanceLock;
    }

    public StatementAgentInstanceFilterVersion getStatementFilterVersion() {
        return this.statementFilterVersion;
    }

    public boolean isCurrentFilter(long filterVersion) {
        return this.statementFilterVersion.isCurrentFilter(filterVersion);
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof EPStatementAgentInstanceHandle)) {
            return false;
        }
        EPStatementAgentInstanceHandle other = (EPStatementAgentInstanceHandle)otherObj;
        return other.statementId.equals(this.statementId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setOptionalDispatchable(EPStatementDispatch optionalDispatchable) {
        this.optionalDispatchable = optionalDispatchable;
    }

    public EPStatementDispatch getOptionalDispatchable() {
        return this.optionalDispatchable;
    }

    public void internalDispatch(ExprEvaluatorContext exprEvaluatorContext) {
        if (this.optionalDispatchable != null) {
            this.optionalDispatchable.execute(exprEvaluatorContext);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }
}

