/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.AgentInstanceFilterProxy;
import com.espertech.esper.core.context.mgr.ContextManagedStatementBase;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.view.OutputProcessViewTerminable;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementAgentInstanceUtil {
    private static final Log log = LogFactory.getLog(EPStatementStopMethodImpl.class);

    public static void stopSafe(Set<StopCallback> terminationCallbacks, List<StopCallback> stopCallbacks, StatementContext statementContext) {
        StopCallback[] terminationArr = terminationCallbacks.toArray(new StopCallback[terminationCallbacks.size()]);
        StatementAgentInstanceUtil.stopSafe(terminationArr, statementContext);
        StopCallback[] stopArr = stopCallbacks.toArray(new StopCallback[stopCallbacks.size()]);
        StatementAgentInstanceUtil.stopSafe(stopArr, statementContext);
    }

    public static void stopSafe(StopCallback[] stopMethods, StatementContext statementContext) {
        for (StopCallback stopCallback : stopMethods) {
            StatementAgentInstanceUtil.stopSafe(stopCallback, statementContext);
        }
    }

    public static void stopSafe(StopCallback stopMethod, StatementContext statementContext) {
        try {
            stopMethod.stop();
        }
        catch (RuntimeException e) {
            log.warn((Object)("Failed to perform statement stop for statement '" + statementContext.getStatementName() + "' expression '" + statementContext.getExpression() + "' : " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(StopCallback stopCallback, AgentInstanceContext agentInstanceContext, Viewable finalView, EPServicesContext servicesContext) {
        StatementAgentInstanceLock lock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        lock.acquireWriteLock(null);
        try {
            if (finalView instanceof OutputProcessViewTerminable) {
                OutputProcessViewTerminable terminable = (OutputProcessViewTerminable)((Object)finalView);
                terminable.terminated();
            }
            StatementAgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext.getStatementContext());
            if (servicesContext.getSchedulableAgentInstanceDirectory() != null) {
                servicesContext.getSchedulableAgentInstanceDirectory().remove(agentInstanceContext.getStatementContext().getStatementId(), agentInstanceContext.getAgentInstanceIds());
            }
            agentInstanceContext.getStatementContext().getMethodResolutionService().destroyedAgentInstance(agentInstanceContext.getAgentInstanceIds());
            agentInstanceContext.getStatementContext().getStatementAgentInstanceRegistry().deassign(agentInstanceContext.getAgentInstanceIds());
            agentInstanceContext.getEpStatementAgentInstanceHandle().setDestroyed(true);
            agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(Long.MAX_VALUE);
        }
        finally {
            lock.releaseWriteLock(null);
        }
    }

    public static StatementAgentInstanceFactoryResult start(EPServicesContext servicesContext, ContextManagedStatementBase statement, boolean isSingleInstanceContext, int agentInstanceId, EventBean agentInstanceProperties, AgentInstanceFilterProxy agentInstanceFilterProxy) {
        StatementContext statementContext = statement.getStatementContext();
        StatementAgentInstanceLock agentInstanceLock = isSingleInstanceContext ? statementContext.getDefaultAgentInstanceLock() : servicesContext.getStatementLockFactory().getStatementLock(statementContext.getStatementName(), statementContext.getExpression(), statementContext.getAnnotations());
        StatementAgentInstanceFilterVersion filterVersion = new StatementAgentInstanceFilterVersion();
        EPStatementAgentInstanceHandle agentInstanceHandle = new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), agentInstanceLock, new int[]{agentInstanceId}, filterVersion);
        AgentInstanceContext agentInstanceContext = new AgentInstanceContext(statementContext, agentInstanceHandle, new int[]{agentInstanceId}, agentInstanceFilterProxy, agentInstanceProperties);
        StatementAgentInstanceFactoryResult startResult = statement.getFactory().newContext(agentInstanceContext);
        startResult.getFinalView().addView(statement.getMergeView());
        AIRegistryExpr aiExprSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
        AIRegistryAggregation aiAggregationSvc = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceAggregationService();
        if (startResult.getOptionalAggegationService() != null) {
            aiAggregationSvc.assignService(agentInstanceId, startResult.getOptionalAggegationService());
        }
        for (Map.Entry<ExprSubselectNode, SubSelectStrategyHolder> entry : startResult.getSubselectStrategies().entrySet()) {
            ExprSubselectNode node = entry.getKey();
            SubSelectStrategyHolder strategyHolder = entry.getValue();
            aiExprSvc.getSubselectService(node).assignService(agentInstanceId, strategyHolder.getStategy());
            for (Map.Entry<ExprPriorNode, ExprPriorEvalStrategy> entry2 : strategyHolder.getPriorStrategies().entrySet()) {
                aiExprSvc.getPriorServices(entry2.getKey()).assignService(agentInstanceId, entry2.getValue());
            }
            for (Map.Entry<ExprNodeBase, Object> entry3 : strategyHolder.getPreviousNodeStrategies().entrySet()) {
                aiExprSvc.getPreviousServices((ExprPreviousNode)entry3.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry3.getValue());
            }
        }
        for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPriorNodeStrategies().entrySet()) {
            aiExprSvc.getPriorServices((ExprPriorNode)entry.getKey()).assignService(agentInstanceId, (ExprPriorEvalStrategy)entry.getValue());
        }
        for (Map.Entry<ExprNodeBase, Object> entry : startResult.getPreviousNodeStrategies().entrySet()) {
            aiExprSvc.getPreviousServices((ExprPreviousNode)entry.getKey()).assignService(agentInstanceId, (ExprPreviousEvalStrategy)entry.getValue());
        }
        return startResult;
    }

    public static void evaluateEventForStatement(EPServicesContext servicesContext, AgentInstanceContext createContextAgentInstanceCtx, EventBean event, AgentInstanceContext agentInstanceContext) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        servicesContext.getFilterService().evaluate(event, callbacks, agentInstanceContext.getStatementContext().getStatementId());
        try {
            servicesContext.getVariableService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                EPStatementHandleCallback callback = (EPStatementHandleCallback)handle;
                if (callback.getAgentInstanceHandle() != agentInstanceContext.getEpStatementAgentInstanceHandle()) continue;
                callback.getFilterCallback().matchFound(event, null);
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch(agentInstanceContext);
            servicesContext.getInternalEventEngineRouteDest().dispatch();
        }
        catch (RuntimeException ex) {
            servicesContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle());
        }
    }
}

