/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPOnDemandQueryResult;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.EPOnDemandPreparedQuerySPI;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPQueryResultImpl;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPPreparedQueryImpl
implements EPOnDemandPreparedQuerySPI {
    private static final Log log = LogFactory.getLog(EPPreparedQueryImpl.class);
    private final EPPreparedExecuteMethod executeMethod;
    private final String epl;

    public EPPreparedQueryImpl(EPPreparedExecuteMethod executeMethod, String epl) {
        this.executeMethod = executeMethod;
        this.epl = epl;
    }

    @Override
    public EPOnDemandQueryResult execute() {
        try {
            EPPreparedQueryResult result = this.executeMethod.execute();
            return new EPQueryResultImpl(result);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.error((Object)("Error executing on-demand statement '" + this.epl + "': " + t.getMessage()), t);
            throw new EPStatementException(message, this.epl);
        }
    }

    @Override
    public EPPreparedExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public EventType getEventType() {
        return this.executeMethod.getEventType();
    }
}

