/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPOnDemandPreparedQuery;
import com.espertech.esper.client.EPOnDemandQueryResult;
import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.client.UnmatchedListener;
import com.espertech.esper.client.VariableNotFoundException;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.client.time.CurrentTimeSpanEvent;
import com.espertech.esper.client.time.TimerControlEvent;
import com.espertech.esper.client.time.TimerEvent;
import com.espertech.esper.client.util.EventRenderer;
import com.espertech.esper.collection.ArrayBackedCollection;
import com.espertech.esper.collection.DualWorkQueue;
import com.espertech.esper.collection.ThreadWorkQueue;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPAdministratorHelper;
import com.espertech.esper.core.service.EPPreparedQueryImpl;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPQueryResultImpl;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.service.EPRuntimeSPI;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExpressionResultCacheService;
import com.espertech.esper.core.service.InsertIntoLatchSpin;
import com.espertech.esper.core.service.InsertIntoLatchWait;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementLifecycleSvcImpl;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.thread.InboundUnitSendDOM;
import com.espertech.esper.core.thread.InboundUnitSendEvent;
import com.espertech.esper.core.thread.InboundUnitSendMap;
import com.espertech.esper.core.thread.RouteUnitMultiple;
import com.espertech.esper.core.thread.RouteUnitSingle;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.TimerUnitMultiple;
import com.espertech.esper.core.thread.TimerUnitSingle;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.event.util.EventRendererImpl;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.timer.TimerCallback;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.MetricUtil;
import com.espertech.esper.util.UuidGenerator;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class EPRuntimeImpl
implements EPRuntimeSPI,
EPRuntimeEventSender,
TimerCallback,
InternalEventRouteDest {
    private EPServicesContext services;
    private boolean isLatchStatementInsertStream;
    private boolean isUsingExternalClocking;
    private boolean isSubselectPreeval;
    private boolean isPrioritized;
    private volatile UnmatchedListener unmatchedListener;
    private AtomicLong routedInternal;
    private AtomicLong routedExternal;
    private EventRenderer eventRenderer;
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>> matchesPerStmtThreadLocal;
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> schedulePerStmtThreadLocal;
    private InternalEventRouter internalEventRouter;
    private ExprEvaluatorContext engineFilterAndDispatchTimeContext;
    private ThreadWorkQueue threadWorkQueue;
    private ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
            return new ArrayBackedCollection<FilterHandle>(100);
        }
    };
    private ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
            return new ArrayBackedCollection<ScheduleHandle>(100);
        }
    };
    private static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeImpl(final EPServicesContext services) {
        this.services = services;
        this.threadWorkQueue = new ThreadWorkQueue();
        this.isLatchStatementInsertStream = this.services.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
        this.isUsingExternalClocking = !this.services.getEngineSettingsService().getEngineSettings().getThreading().isInternalTimerEnabled();
        this.isSubselectPreeval = services.getEngineSettingsService().getEngineSettings().getExpression().isSelfSubselectPreeval();
        this.isPrioritized = services.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.routedInternal = new AtomicLong();
        this.routedExternal = new AtomicLong();
        this.engineFilterAndDispatchTimeContext = new ExprEvaluatorContext(){
            private ExpressionResultCacheService expressionResultCacheService = new ExpressionResultCacheService();

            @Override
            public TimeProvider getTimeProvider() {
                return services.getSchedulingService();
            }

            @Override
            public ExpressionResultCacheService getExpressionResultCacheService() {
                return this.expressionResultCacheService;
            }

            @Override
            public int[] getAgentInstanceIds() {
                return null;
            }

            @Override
            public EventBean getContextProperties() {
                return null;
            }
        };
        this.matchesPerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>(new Comparator<EPStatementAgentInstanceHandle>(){

                        @Override
                        public int compare(EPStatementAgentInstanceHandle o1, EPStatementAgentInstanceHandle o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1.equals(o2)) {
                                return 0;
                            }
                            return o1.getPriority() >= o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>(10000);
            }
        };
        this.schedulePerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
                if (EPRuntimeImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, Object>(new Comparator<EPStatementAgentInstanceHandle>(){

                        @Override
                        public int compare(EPStatementAgentInstanceHandle o1, EPStatementAgentInstanceHandle o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1.equals(o2)) {
                                return 0;
                            }
                            return o1.getPriority() >= o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementAgentInstanceHandle, Object>(10000);
            }
        };
        services.getThreadingService().initThreading(services, this);
    }

    @Override
    public void setInternalEventRouter(InternalEventRouter internalEventRouter) {
        this.internalEventRouter = internalEventRouter;
    }

    @Override
    public long getRoutedInternal() {
        return this.routedInternal.get();
    }

    @Override
    public long getRoutedExternal() {
        return this.routedExternal.get();
    }

    @Override
    public void timerCallback() {
        long msec = this.services.getTimeSource().getTimeMillis();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)(".timerCallback Evaluating scheduled callbacks, time is " + msec));
        }
        CurrentTimeEvent currentTimeEvent = new CurrentTimeEvent(msec);
        this.sendEvent(currentTimeEvent);
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        if (event == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(event instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug((Object)(".sendEvent Processing event " + event));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendEvent(event, this));
        } else {
            this.processEvent(event);
        }
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendDOM(document, this.services, this));
        } else {
            EventBean eventBean = this.wrapEvent(document);
            this.processEvent(eventBean);
        }
    }

    @Override
    public EventBean wrapEvent(Node node) {
        return this.services.getEventAdapterService().adapterForDOM(node);
    }

    @Override
    public void route(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        EventBean eventBean = this.services.getEventAdapterService().adapterForDOM(document);
        this.threadWorkQueue.addBack(eventBean);
    }

    @Override
    public void sendEvent(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendMap Processing event " + map));
        }
        if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isInboundThreading()) {
            this.services.getThreadingService().submitInbound(new InboundUnitSendMap(map, eventTypeName, this.services, this));
        } else {
            EventBean eventBean = this.wrapEvent(map, eventTypeName);
            this.processWrappedEvent(eventBean);
        }
    }

    @Override
    public EventBean wrapEvent(Map map, String eventTypeName) {
        return this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
    }

    @Override
    public void route(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".route Processing event " + map));
        }
        EventBean event = this.services.getEventAdapterService().adapterForMap(map, eventTypeName);
        if (this.internalEventRouter.isHasPreprocessing() && (event = this.internalEventRouter.preprocess(event, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.threadWorkQueue.addBack(event);
    }

    @Override
    public long getNumEventsEvaluated() {
        return this.services.getFilterService().getNumEventsEvaluated();
    }

    @Override
    public void resetStats() {
        this.services.getFilterService().resetStats();
        this.routedInternal.set(0L);
        this.routedExternal.set(0L);
    }

    @Override
    public void routeEventBean(EventBean event) {
        this.threadWorkQueue.addBack(event);
    }

    @Override
    public void route(Object event) {
        EventBean eventBean;
        this.routedExternal.incrementAndGet();
        if (this.internalEventRouter.isHasPreprocessing() && (event = this.internalEventRouter.preprocess(eventBean = this.services.getEventAdapterService().adapterForBean(event), this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.threadWorkQueue.addBack(event);
    }

    @Override
    public void route(EventBean event, EPStatementHandle epStatementHandle, boolean addToFront) {
        this.routedInternal.incrementAndGet();
        if (this.isLatchStatementInsertStream) {
            if (addToFront) {
                Object latch = epStatementHandle.getInsertIntoFrontLatchFactory().newLatch(event);
                this.threadWorkQueue.addFront(latch);
            } else {
                Object latch = epStatementHandle.getInsertIntoBackLatchFactory().newLatch(event);
                this.threadWorkQueue.addBack(latch);
            }
        } else if (addToFront) {
            this.threadWorkQueue.addFront(event);
        } else {
            this.threadWorkQueue.addBack(event);
        }
    }

    public void processEvent(Object event) {
        if (event instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)event);
            return;
        }
        EventBean eventBean = event instanceof EventBean ? (EventBean)event : this.wrapEvent(event);
        this.processWrappedEvent(eventBean);
    }

    @Override
    public EventBean wrapEvent(Object event) {
        return this.services.getEventAdapterService().adapterForBean(event);
    }

    @Override
    public void processWrappedEvent(EventBean eventBean) {
        if (this.internalEventRouter.isHasPreprocessing() && (eventBean = this.internalEventRouter.preprocess(eventBean, this.engineFilterAndDispatchTimeContext)) == null) {
            return;
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw new EPException(ex);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent event) {
        if (event instanceof TimerControlEvent) {
            TimerControlEvent timerControlEvent = (TimerControlEvent)event;
            if (timerControlEvent.getClockType() == TimerControlEvent.ClockType.CLOCK_INTERNAL) {
                this.services.getTimerService().startInternalClock();
                this.isUsingExternalClocking = false;
            } else {
                this.services.getTimerService().stopInternalClock(true);
                this.isUsingExternalClocking = true;
            }
            return;
        }
        if (event instanceof CurrentTimeEvent) {
            CurrentTimeEvent current = (CurrentTimeEvent)event;
            long currentTime = current.getTimeInMillis();
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                log.debug((Object)(".processTimeEvent Setting time and evaluating schedules for time " + currentTime));
            }
            if (this.isUsingExternalClocking && currentTime == this.services.getSchedulingService().getTime() && log.isWarnEnabled()) {
                log.warn((Object)("Duplicate time event received for currentTime " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            if (MetricReportingPath.isMetricsEnabled) {
                this.services.getMetricsReportingService().processTimeEvent(currentTime);
            }
            this.processSchedule();
            this.dispatch();
            this.processThreadWorkQueue();
            return;
        }
        CurrentTimeSpanEvent span = (CurrentTimeSpanEvent)event;
        long targetTime = span.getTargetTimeInMillis();
        long currentTime = this.services.getSchedulingService().getTime();
        Long optionalResolution = span.getOptionalResolution();
        if (this.isUsingExternalClocking && targetTime < currentTime && log.isWarnEnabled()) {
            log.warn((Object)("Past or current time event received for currentTime " + targetTime));
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)(".processTimeEvent Setting time span and evaluating schedules for time " + targetTime + " optional resolution " + span.getOptionalResolution()));
        }
        while (currentTime < targetTime) {
            Long nearest;
            currentTime = optionalResolution != null && optionalResolution > 0L ? (currentTime += optionalResolution.longValue()) : ((nearest = this.services.getSchedulingService().getNearestTimeHandle()) == null ? targetTime : nearest);
            if (currentTime > targetTime) {
                currentTime = targetTime;
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                log.debug((Object)(".processTimeEvent Setting time and evaluating schedules for time " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            if (MetricReportingPath.isMetricsEnabled) {
                this.services.getMetricsReportingService().processTimeEvent(currentTime);
            }
            this.processSchedule();
            this.dispatch();
            this.processThreadWorkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSchedule() {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        catch (RuntimeException ex) {
            handles.clear();
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
    }

    private void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementAgentInstanceHandle handle;
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            if (MetricReportingPath.isMetricsEnabled && handle2.getAgentInstanceHandle().getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services, this.engineFilterAndDispatchTimeContext);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle2.getAgentInstanceHandle().getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitSingle(this.services, this, handle2, this.engineFilterAndDispatchTimeContext));
            } else {
                EPRuntimeImpl.processStatementScheduleSingle(handle2, this.services, this.engineFilterAndDispatchTimeContext);
            }
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        Map<EPStatementAgentInstanceHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                ArrayDeque<ScheduleHandleCallback> entries = new ArrayDeque<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            ArrayDeque entries = (ArrayDeque)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services, this.engineFilterAndDispatchTimeContext);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                int numInput = callbackObject instanceof Collection ? ((Collection)callbackObject).size() : 1;
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, numInput);
            } else if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isTimerThreading()) {
                this.services.getThreadingService().submitTimerWork(new TimerUnitMultiple(this.services, this, handle, callbackObject, this.engineFilterAndDispatchTimeContext));
            } else {
                EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.services, this.engineFilterAndDispatchTimeContext);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    @Override
    public void processThreadWorkQueue() {
        Object item;
        boolean haveDispatched;
        DualWorkQueue queues = this.threadWorkQueue.getThreadQueue();
        if (queues.getFrontQueue().isEmpty()) {
            boolean haveDispatched2 = this.services.getNamedWindowService().dispatch(this.engineFilterAndDispatchTimeContext);
            if (haveDispatched2) {
                this.dispatch();
            }
        } else {
            Object item2;
            while ((item2 = queues.getFrontQueue().poll()) != null) {
                if (item2 instanceof InsertIntoLatchSpin) {
                    this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item2);
                } else if (item2 instanceof InsertIntoLatchWait) {
                    this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item2);
                } else {
                    this.processThreadWorkQueueUnlatched(item2);
                }
                if (!(haveDispatched = this.services.getNamedWindowService().dispatch(this.engineFilterAndDispatchTimeContext))) continue;
                this.dispatch();
            }
        }
        while ((item = queues.getBackQueue().poll()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
            } else if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
            } else {
                this.processThreadWorkQueueUnlatched(item);
            }
            haveDispatched = this.services.getNamedWindowService().dispatch(this.engineFilterAndDispatchTimeContext);
            if (haveDispatched) {
                this.dispatch();
            }
            if (queues.getFrontQueue().isEmpty()) continue;
            this.processThreadWorkQueue();
        }
    }

    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.services.getEventAdapterService().adapterForBean(item);
        this.services.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            this.services.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMatches(EventBean event) {
        EPStatementAgentInstanceHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        long version = this.services.getFilterService().evaluate(event, matches);
        if (matches.size() == 0) {
            if (this.unmatchedListener != null) {
                this.services.getEventProcessingRWLock().releaseReadLock();
                try {
                    this.unmatchedListener.update(event);
                }
                catch (Throwable t) {
                    log.error((Object)("Exception thrown by unmatched listener: " + t.getMessage()), t);
                }
                finally {
                    this.services.getEventProcessingRWLock().acquireReadLock();
                }
            }
            return;
        }
        Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDeque<FilterHandleCallback> callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    callbacks = new ArrayDeque();
                    stmtCallbacks.put(handle, callbacks);
                }
                callbacks.add(handleCallback.getFilterCallback());
                continue;
            }
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterSingle(handle, handleCallback, event, version);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                continue;
            }
            if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitSingle(this, handleCallback, event, version));
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, event, version);
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            ArrayDeque<FilterHandleCallback> callbackList = entry.getValue();
            if (MetricReportingPath.isMetricsEnabled && handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                long wallTimeBefore = MetricUtil.getWall();
                this.processStatementFilterMultiple(handle, callbackList, event, version);
                long wallTimeAfter = MetricUtil.getWall();
                long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                long deltaWall = wallTimeAfter - wallTimeBefore;
                this.services.getMetricsReportingService().accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, callbackList.size());
                continue;
            }
            if (ThreadingOption.isThreadingEnabled && this.services.getThreadingService().isRouteThreading()) {
                this.services.getThreadingService().submitRoute(new RouteUnitMultiple(this, callbackList, event, handle, version));
            } else {
                this.processStatementFilterMultiple(handle, callbackList, event, version);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        stmtCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleMultiple(EPStatementAgentInstanceHandle handle, Object callbackObject, EPServicesContext services, ExprEvaluatorContext exprEvaluatorContext) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(services.getStatementLockFactory());
        try {
            if (!handle.isDestroyed()) {
                if (handle.isHasVariables()) {
                    services.getVariableService().setLocalVersion();
                }
                if (callbackObject instanceof ArrayDeque) {
                    ArrayDeque callbackList = (ArrayDeque)callbackObject;
                    for (ScheduleHandleCallback callback : callbackList) {
                        callback.scheduledTrigger(services.getExtensionServicesContext());
                    }
                } else {
                    ScheduleHandleCallback callback = (ScheduleHandleCallback)callbackObject;
                    callback.scheduledTrigger(services.getExtensionServicesContext());
                }
                handle.internalDispatch(exprEvaluatorContext);
            }
        }
        catch (RuntimeException ex) {
            services.getExceptionHandlingService().handleException(ex, handle);
        }
        finally {
            handle.getStatementAgentInstanceLock().releaseWriteLock(services.getStatementLockFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatementScheduleSingle(EPStatementHandleCallback handle, EPServicesContext services, ExprEvaluatorContext exprEvaluatorContext) {
        StatementAgentInstanceLock statementLock = handle.getAgentInstanceHandle().getStatementAgentInstanceLock();
        statementLock.acquireWriteLock(services.getStatementLockFactory());
        try {
            if (!handle.getAgentInstanceHandle().isDestroyed()) {
                if (handle.getAgentInstanceHandle().isHasVariables()) {
                    services.getVariableService().setLocalVersion();
                }
                handle.getScheduleCallback().scheduledTrigger(services.getExtensionServicesContext());
                handle.getAgentInstanceHandle().internalDispatch(exprEvaluatorContext);
            }
        }
        catch (RuntimeException ex) {
            services.getExceptionHandlingService().handleException(ex, handle.getAgentInstanceHandle());
        }
        finally {
            handle.getAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock(services.getStatementLockFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterMultiple(EPStatementAgentInstanceHandle handle, ArrayDeque<FilterHandleCallback> callbackList, EventBean event, long version) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.services.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version)) {
                callbackList.clear();
                ArrayDeque<FilterHandle> callbackListNew = this.getCallbackList(event, handle.getStatementId());
                for (FilterHandle callback : callbackListNew) {
                    EPStatementHandleCallback handleCallbackFilter = (EPStatementHandleCallback)callback;
                    callbackList.add(handleCallbackFilter.getFilterCallback());
                }
            }
            if (this.isSubselectPreeval) {
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
            } else {
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
            }
            handle.internalDispatch(this.engineFilterAndDispatchTimeContext);
        }
        catch (RuntimeException ex) {
            this.services.getExceptionHandlingService().handleException(ex, handle);
        }
        finally {
            handle.getStatementAgentInstanceLock().releaseWriteLock(this.services.getStatementLockFactory());
        }
    }

    private ArrayDeque<FilterHandle> getCallbackList(EventBean event, String statementId) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        this.services.getFilterService().evaluate(event, callbacks, statementId);
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterSingle(EPStatementAgentInstanceHandle handle, EPStatementHandleCallback handleCallback, EventBean event, long version) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.services.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.services.getVariableService().setLocalVersion();
            }
            if (!handle.isCurrentFilter(version)) {
                ArrayDeque<FilterHandle> callbackList = this.getCallbackList(event, handle.getStatementId());
                for (FilterHandle callback : callbackList) {
                    EPStatementHandleCallback handleCallbackFilter = (EPStatementHandleCallback)callback;
                    handleCallbackFilter.getFilterCallback().matchFound(event, null);
                }
            } else {
                handleCallback.getFilterCallback().matchFound(event, null);
            }
            handle.internalDispatch(this.engineFilterAndDispatchTimeContext);
        }
        catch (RuntimeException ex) {
            this.services.getExceptionHandlingService().handleException(ex, handle);
        }
        finally {
            handleCallback.getAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock(this.services.getStatementLockFactory());
        }
    }

    @Override
    public void dispatch() {
        try {
            this.services.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    @Override
    public void destroy() {
        this.services = null;
        if (this.matchesArrayThreadLocal != null) {
            this.matchesArrayThreadLocal.remove();
        }
        if (this.matchesPerStmtThreadLocal != null) {
            this.matchesPerStmtThreadLocal.remove();
        }
        if (this.scheduleArrayThreadLocal != null) {
            this.scheduleArrayThreadLocal.remove();
        }
        if (this.schedulePerStmtThreadLocal != null) {
            this.schedulePerStmtThreadLocal.remove();
        }
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public void initialize() {
        this.matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

            @Override
            protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
                return new ArrayBackedCollection<FilterHandle>(100);
            }
        };
        this.scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

            @Override
            protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
                return new ArrayBackedCollection<ScheduleHandle>(100);
            }
        };
        this.threadWorkQueue = new ThreadWorkQueue();
    }

    @Override
    public void setUnmatchedListener(UnmatchedListener listener) {
        this.unmatchedListener = listener;
    }

    @Override
    public void setVariableValue(String variableName, Object variableValue) throws EPException {
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        this.services.getVariableService().checkAndWrite(reader.getVariableNumber(), variableValue);
        this.services.getVariableService().commit();
    }

    @Override
    public void setVariableValue(Map<String, Object> variableValues) throws EPException {
        for (Map.Entry<String, Object> entry : variableValues.entrySet()) {
            String variableName = entry.getKey();
            VariableReader reader = this.services.getVariableService().getReader(variableName);
            if (reader == null) {
                this.services.getVariableService().rollback();
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            try {
                this.services.getVariableService().checkAndWrite(reader.getVariableNumber(), entry.getValue());
            }
            catch (RuntimeException ex) {
                this.services.getVariableService().rollback();
                throw ex;
            }
        }
        this.services.getVariableService().commit();
    }

    @Override
    public Object getVariableValue(String variableName) throws EPException {
        this.services.getVariableService().setLocalVersion();
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
        }
        Object value = reader.getValue();
        if (value == null || reader.getEventType() == null) {
            return value;
        }
        return ((EventBean)value).getUnderlying();
    }

    @Override
    public Map<String, Object> getVariableValue(Set<String> variableNames) throws EPException {
        this.services.getVariableService().setLocalVersion();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String variableName : variableNames) {
            VariableReader reader = this.services.getVariableService().getReader(variableName);
            if (reader == null) {
                throw new VariableNotFoundException("Variable by name '" + variableName + "' has not been declared");
            }
            Object value = reader.getValue();
            if (value != null && reader.getEventType() != null) {
                value = ((EventBean)value).getUnderlying();
            }
            values.put(variableName, value);
        }
        return values;
    }

    @Override
    public Map<String, Object> getVariableValueAll() throws EPException {
        this.services.getVariableService().setLocalVersion();
        Map<String, VariableReader> variables = this.services.getVariableService().getVariables();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Object value = entry.getValue().getValue();
            values.put(entry.getValue().getVariableName(), value);
        }
        return values;
    }

    @Override
    public Map<String, Class> getVariableTypeAll() {
        Map<String, VariableReader> variables = this.services.getVariableService().getVariables();
        HashMap<String, Class> values = new HashMap<String, Class>();
        for (Map.Entry<String, VariableReader> entry : variables.entrySet()) {
            Class type = entry.getValue().getType();
            values.put(entry.getValue().getVariableName(), type);
        }
        return values;
    }

    @Override
    public Class getVariableType(String variableName) {
        VariableReader reader = this.services.getVariableService().getReader(variableName);
        if (reader == null) {
            return null;
        }
        return reader.getType();
    }

    @Override
    public EPOnDemandQueryResult executeQuery(String epl) {
        try {
            EPPreparedExecuteMethod executeMethod = this.getExecuteMethod(epl);
            EPPreparedQueryResult result = executeMethod.execute();
            return new EPQueryResultImpl(result);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.info((Object)message, t);
            throw new EPStatementException(message, epl);
        }
    }

    @Override
    public EPOnDemandPreparedQuery prepareQuery(String epl) {
        try {
            EPPreparedExecuteMethod startMethod = this.getExecuteMethod(epl);
            return new EPPreparedQueryImpl(startMethod, epl);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug((Object)message, t);
            throw new EPStatementException(message, epl);
        }
    }

    private EPPreparedExecuteMethod getExecuteMethod(String epl) {
        String stmtName = UuidGenerator.generate();
        String stmtId = UuidGenerator.generate();
        try {
            StatementSpecRaw spec = EPAdministratorHelper.compileEPL(epl, epl, true, stmtName, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
            Annotation[] annotations = AnnotationUtil.compileAnnotations(spec.getAnnotations(), this.services.getEngineImportService(), epl);
            StatementContext statementContext = this.services.getStatementContextFactory().makeContext(stmtId, stmtName, epl, false, this.services, null, null, null, true, annotations, null, null, null);
            StatementSpecCompiled compiledSpec = StatementLifecycleSvcImpl.compile(spec, epl, statementContext, true, annotations);
            return new EPPreparedExecuteMethod(compiledSpec, this.services, statementContext);
        }
        catch (EPStatementException ex) {
            throw ex;
        }
        catch (Throwable t) {
            String message = "Error executing statement: " + t.getMessage();
            log.debug((Object)message, t);
            throw new EPStatementException(message, t, epl);
        }
    }

    @Override
    public EventSender getEventSender(String eventTypeName) {
        return this.services.getEventAdapterService().getStaticTypeEventSender(this, eventTypeName, this.services.getThreadingService());
    }

    @Override
    public EventSender getEventSender(URI[] uri) throws EventTypeException {
        return this.services.getEventAdapterService().getDynamicTypeEventSender(this, uri, this.services.getThreadingService());
    }

    @Override
    public EventRenderer getEventRenderer() {
        if (this.eventRenderer == null) {
            this.eventRenderer = new EventRendererImpl();
        }
        return this.eventRenderer;
    }

    @Override
    public long getCurrentTime() {
        return this.services.getSchedulingService().getTime();
    }

    @Override
    public Long getNextScheduledTime() {
        return this.services.getSchedulingService().getNearestTimeHandle();
    }

    @Override
    public Map<String, Long> getStatementNearestSchedules() {
        return EPRuntimeImpl.getStatementNearestSchedulesInternal(this.services.getSchedulingService(), this.services.getStatementLifecycleSvc());
    }

    protected static Map<String, Long> getStatementNearestSchedulesInternal(SchedulingServiceSPI schedulingService, StatementLifecycleSvc statementLifecycleSvc) {
        Map<String, Long> schedulePerStatementId = schedulingService.getStatementSchedules();
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry<String, Long> schedule : schedulePerStatementId.entrySet()) {
            String stmtName = statementLifecycleSvc.getStatementNameById(schedule.getKey());
            if (stmtName == null) continue;
            result.put(stmtName, schedule.getValue());
        }
        return result;
    }
}

