/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.client.time.CurrentTimeSpanEvent;
import com.espertech.esper.client.time.TimerControlEvent;
import com.espertech.esper.client.time.TimerEvent;
import com.espertech.esper.collection.ArrayBackedCollection;
import com.espertech.esper.collection.DualWorkQueue;
import com.espertech.esper.collection.ThreadWorkQueue;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPRuntimeIsolatedSPI;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.InsertIntoLatchSpin;
import com.espertech.esper.core.service.InsertIntoLatchWait;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContextTimeOnly;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class EPRuntimeIsolatedImpl
implements EPRuntimeIsolatedSPI,
InternalEventRouteDest {
    private EPServicesContext unisolatedServices;
    private EPIsolationUnitServices services;
    private boolean isSubselectPreeval;
    private boolean isPrioritized;
    private boolean isLatchStatementInsertStream;
    private ExprEvaluatorContext isolatedTimeEvalContext;
    private ThreadWorkQueue threadWorkQueue;
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>> matchesPerStmtThreadLocal;
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> schedulePerStmtThreadLocal;
    private ThreadLocal<ArrayBackedCollection<FilterHandle>> matchesArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<FilterHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<FilterHandle> initialValue() {
            return new ArrayBackedCollection<FilterHandle>(100);
        }
    };
    private ThreadLocal<ArrayBackedCollection<ScheduleHandle>> scheduleArrayThreadLocal = new ThreadLocal<ArrayBackedCollection<ScheduleHandle>>(){

        @Override
        protected synchronized ArrayBackedCollection<ScheduleHandle> initialValue() {
            return new ArrayBackedCollection<ScheduleHandle>(100);
        }
    };
    private static final Log log = LogFactory.getLog(EPRuntimeImpl.class);

    public EPRuntimeIsolatedImpl(EPIsolationUnitServices svc, EPServicesContext unisolatedSvc) {
        this.services = svc;
        this.unisolatedServices = unisolatedSvc;
        this.threadWorkQueue = new ThreadWorkQueue();
        this.isSubselectPreeval = unisolatedSvc.getEngineSettingsService().getEngineSettings().getExpression().isSelfSubselectPreeval();
        this.isPrioritized = unisolatedSvc.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        this.isLatchStatementInsertStream = unisolatedSvc.getEngineSettingsService().getEngineSettings().getThreading().isInsertIntoDispatchPreserveOrder();
        this.isolatedTimeEvalContext = new ExprEvaluatorContextTimeOnly(this.services.getSchedulingService());
        this.matchesPerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> initialValue() {
                if (EPRuntimeIsolatedImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>(new Comparator<EPStatementAgentInstanceHandle>(){

                        @Override
                        public int compare(EPStatementAgentInstanceHandle o1, EPStatementAgentInstanceHandle o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1.equals(o2)) {
                                return 0;
                            }
                            return o1.getPriority() >= o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>>(10000);
            }
        };
        this.schedulePerStmtThreadLocal = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

            @Override
            protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
                if (EPRuntimeIsolatedImpl.this.isPrioritized) {
                    return new TreeMap<EPStatementAgentInstanceHandle, Object>(new Comparator<EPStatementAgentInstanceHandle>(){

                        @Override
                        public int compare(EPStatementAgentInstanceHandle o1, EPStatementAgentInstanceHandle o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1.equals(o2)) {
                                return 0;
                            }
                            return o1.getPriority() >= o2.getPriority() ? -1 : 1;
                        }
                    });
                }
                return new HashMap<EPStatementAgentInstanceHandle, Object>(10000);
            }
        };
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        if (event == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(event instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug((Object)(".sendEvent Processing event " + event));
        }
        this.processEvent(event);
    }

    @Override
    public void sendEvent(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForDOM(document);
        this.processEvent(eventBean);
    }

    public void route(Node document) throws EPException {
        if (document == null) {
            log.fatal((Object)".sendEvent Null object supplied");
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendEvent Processing DOM node event " + document));
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForDOM(document);
        this.threadWorkQueue.addBack(eventBean);
    }

    @Override
    public void sendEvent(Map map, String eventTypeName) throws EPException {
        if (map == null) {
            throw new IllegalArgumentException("Invalid null event object");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".sendMap Processing event " + map));
        }
        EventBean eventBean = this.unisolatedServices.getEventAdapterService().adapterForMap(map, eventTypeName);
        this.processWrappedEvent(eventBean);
    }

    public void processEvent(Object event) {
        if (event instanceof TimerEvent) {
            this.processTimeEvent((TimerEvent)event);
            return;
        }
        EventBean eventBean = event instanceof EventBean ? (EventBean)event : this.unisolatedServices.getEventAdapterService().adapterForBean(event);
        this.processWrappedEvent(eventBean);
    }

    public void processWrappedEvent(EventBean eventBean) {
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw new EPException(ex);
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
        this.processThreadWorkQueue();
    }

    private void processTimeEvent(TimerEvent event) {
        if (event instanceof TimerControlEvent) {
            TimerControlEvent tce = (TimerControlEvent)event;
            if (tce.getClockType() == TimerControlEvent.ClockType.CLOCK_INTERNAL) {
                log.warn((Object)"Timer control events are not processed by the isolated runtime as the setting is always external timer.");
            }
            return;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)".processTimeEvent Setting time and evaluating schedules");
        }
        if (event instanceof CurrentTimeEvent) {
            CurrentTimeEvent current = (CurrentTimeEvent)event;
            long currentTime = current.getTimeInMillis();
            if (currentTime == this.services.getSchedulingService().getTime() && log.isWarnEnabled()) {
                log.warn((Object)("Duplicate time event received for currentTime " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            this.processSchedule();
            this.dispatch();
            this.processThreadWorkQueue();
            return;
        }
        CurrentTimeSpanEvent span = (CurrentTimeSpanEvent)event;
        long targetTime = span.getTargetTimeInMillis();
        long currentTime = this.services.getSchedulingService().getTime();
        Long optionalResolution = span.getOptionalResolution();
        if (targetTime < currentTime && log.isWarnEnabled()) {
            log.warn((Object)("Past or current time event received for currentTime " + targetTime));
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
            log.debug((Object)(".processTimeEvent Setting time span and evaluating schedules for time " + targetTime + " optional resolution " + span.getOptionalResolution()));
        }
        while (currentTime < targetTime) {
            Long nearest;
            currentTime = optionalResolution != null && optionalResolution > 0L ? (currentTime += optionalResolution.longValue()) : ((nearest = this.services.getSchedulingService().getNearestTimeHandle()) == null ? targetTime : nearest);
            if (currentTime > targetTime) {
                currentTime = targetTime;
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                log.debug((Object)(".processTimeEvent Setting time and evaluating schedules for time " + currentTime));
            }
            this.services.getSchedulingService().setTime(currentTime);
            this.processSchedule();
            this.dispatch();
            this.processThreadWorkQueue();
        }
    }

    private void processSchedule() {
        ArrayBackedCollection<ScheduleHandle> handles = this.scheduleArrayThreadLocal.get();
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.services.getSchedulingService().evaluate(handles);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processScheduleHandles(handles);
        }
        catch (RuntimeException ex) {
            handles.clear();
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
    }

    private void processScheduleHandles(ArrayBackedCollection<ScheduleHandle> handles) {
        EPStatementAgentInstanceHandle handle;
        if (handles.size() == 0) {
            return;
        }
        if (handles.size() == 1) {
            Object[] handleArray = handles.getArray();
            EPStatementHandleCallback handle2 = (EPStatementHandleCallback)handleArray[0];
            EPRuntimeImpl.processStatementScheduleSingle(handle2, this.unisolatedServices, this.isolatedTimeEvalContext);
            handles.clear();
            return;
        }
        Object[] matchArray = handles.getArray();
        int entryCount = handles.size();
        Map<EPStatementAgentInstanceHandle, Object> stmtCallbacks = this.schedulePerStmtThreadLocal.get();
        stmtCallbacks.clear();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            ScheduleHandleCallback callback = handleCallback.getScheduleCallback();
            Object entry = stmtCallbacks.get(handle);
            if (entry == null) {
                stmtCallbacks.put(handle, callback);
                continue;
            }
            if (entry instanceof ScheduleHandleCallback) {
                ScheduleHandleCallback existingCallback = (ScheduleHandleCallback)entry;
                ArrayDeque<ScheduleHandleCallback> entries = new ArrayDeque<ScheduleHandleCallback>();
                entries.add(existingCallback);
                entries.add(callback);
                stmtCallbacks.put(handle, entries);
                continue;
            }
            ArrayDeque entries = (ArrayDeque)entry;
            entries.add(callback);
        }
        handles.clear();
        for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            Object callbackObject = entry.getValue();
            EPRuntimeImpl.processStatementScheduleMultiple(handle, callbackObject, this.unisolatedServices, this.isolatedTimeEvalContext);
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
    }

    @Override
    public void processThreadWorkQueue() {
        Object item;
        boolean haveDispatched;
        DualWorkQueue queues = this.threadWorkQueue.getThreadQueue();
        if (queues.getFrontQueue().isEmpty()) {
            boolean haveDispatched2 = this.unisolatedServices.getNamedWindowService().dispatch(this.isolatedTimeEvalContext);
            if (haveDispatched2) {
                this.dispatch();
            }
        } else {
            Object item2;
            while ((item2 = queues.getFrontQueue().poll()) != null) {
                if (item2 instanceof InsertIntoLatchSpin) {
                    this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item2);
                } else if (item2 instanceof InsertIntoLatchWait) {
                    this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item2);
                } else {
                    this.processThreadWorkQueueUnlatched(item2);
                }
                if (!(haveDispatched = this.unisolatedServices.getNamedWindowService().dispatch(this.isolatedTimeEvalContext))) continue;
                this.dispatch();
            }
        }
        while ((item = queues.getBackQueue().poll()) != null) {
            if (item instanceof InsertIntoLatchSpin) {
                this.processThreadWorkQueueLatchedSpin((InsertIntoLatchSpin)item);
            } else if (item instanceof InsertIntoLatchWait) {
                this.processThreadWorkQueueLatchedWait((InsertIntoLatchWait)item);
            } else {
                this.processThreadWorkQueueUnlatched(item);
            }
            haveDispatched = this.unisolatedServices.getNamedWindowService().dispatch(this.isolatedTimeEvalContext);
            if (haveDispatched) {
                this.dispatch();
            }
            if (queues.getFrontQueue().isEmpty()) continue;
            this.processThreadWorkQueue();
        }
    }

    private void processThreadWorkQueueLatchedWait(InsertIntoLatchWait insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueLatchedSpin(InsertIntoLatchSpin insertIntoLatch) {
        EventBean eventBean = insertIntoLatch.await();
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            insertIntoLatch.done();
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processThreadWorkQueueUnlatched(Object item) {
        EventBean eventBean = item instanceof EventBean ? (EventBean)item : this.unisolatedServices.getEventAdapterService().adapterForBean(item);
        this.unisolatedServices.getEventProcessingRWLock().acquireReadLock();
        try {
            this.processMatches(eventBean);
        }
        catch (RuntimeException ex) {
            this.matchesArrayThreadLocal.get().clear();
            throw ex;
        }
        finally {
            this.unisolatedServices.getEventProcessingRWLock().releaseReadLock();
        }
        this.dispatch();
    }

    private void processMatches(EventBean event) {
        EPStatementAgentInstanceHandle handle;
        ArrayBackedCollection<FilterHandle> matches = this.matchesArrayThreadLocal.get();
        this.services.getFilterService().evaluate(event, matches);
        if (matches.size() == 0) {
            return;
        }
        Map<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> stmtCallbacks = this.matchesPerStmtThreadLocal.get();
        Object[] matchArray = matches.getArray();
        int entryCount = matches.size();
        for (int i = 0; i < entryCount; ++i) {
            EPStatementHandleCallback handleCallback = (EPStatementHandleCallback)matchArray[i];
            handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || this.isPrioritized) {
                ArrayDeque<FilterHandleCallback> callbacks = stmtCallbacks.get(handle);
                if (callbacks == null) {
                    callbacks = new ArrayDeque();
                    stmtCallbacks.put(handle, callbacks);
                }
                callbacks.add(handleCallback.getFilterCallback());
                continue;
            }
            this.processStatementFilterSingle(handle, handleCallback, event);
        }
        matches.clear();
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry<EPStatementAgentInstanceHandle, ArrayDeque<FilterHandleCallback>> entry : stmtCallbacks.entrySet()) {
            handle = entry.getKey();
            ArrayDeque<FilterHandleCallback> callbackList = entry.getValue();
            this.processStatementFilterMultiple(handle, callbackList, event);
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        stmtCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterMultiple(EPStatementAgentInstanceHandle handle, ArrayDeque<FilterHandleCallback> callbackList, EventBean event) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.unisolatedServices.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.unisolatedServices.getVariableService().setLocalVersion();
            }
            if (this.isSubselectPreeval) {
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
            } else {
                for (FilterHandleCallback callback : callbackList) {
                    if (callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
                for (FilterHandleCallback callback : callbackList) {
                    if (!callback.isSubSelect()) continue;
                    callback.matchFound(event, callbackList);
                }
            }
            handle.internalDispatch(this.isolatedTimeEvalContext);
        }
        catch (RuntimeException ex) {
            this.unisolatedServices.getExceptionHandlingService().handleException(ex, handle);
        }
        finally {
            handle.getStatementAgentInstanceLock().releaseWriteLock(this.unisolatedServices.getStatementLockFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStatementFilterSingle(EPStatementAgentInstanceHandle handle, EPStatementHandleCallback handleCallback, EventBean event) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.unisolatedServices.getStatementLockFactory());
        try {
            if (handle.isHasVariables()) {
                this.unisolatedServices.getVariableService().setLocalVersion();
            }
            handleCallback.getFilterCallback().matchFound(event, null);
            handle.internalDispatch(this.isolatedTimeEvalContext);
        }
        catch (RuntimeException ex) {
            this.unisolatedServices.getExceptionHandlingService().handleException(ex, handle);
        }
        finally {
            handleCallback.getAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock(this.unisolatedServices.getStatementLockFactory());
        }
    }

    @Override
    public void dispatch() {
        try {
            this.unisolatedServices.getDispatchService().dispatch();
        }
        catch (RuntimeException ex) {
            throw new EPException(ex);
        }
    }

    public void destroy() {
        this.services = null;
        this.matchesArrayThreadLocal.remove();
        this.matchesPerStmtThreadLocal.remove();
        this.scheduleArrayThreadLocal.remove();
        this.schedulePerStmtThreadLocal.remove();
        this.matchesArrayThreadLocal = null;
        this.matchesPerStmtThreadLocal = null;
        this.scheduleArrayThreadLocal = null;
        this.schedulePerStmtThreadLocal = null;
    }

    @Override
    public long getCurrentTime() {
        return this.services.getSchedulingService().getTime();
    }

    @Override
    public void route(EventBean event, EPStatementHandle epStatementHandle, boolean addToFront) {
        if (this.isLatchStatementInsertStream) {
            if (addToFront) {
                Object latch = epStatementHandle.getInsertIntoFrontLatchFactory().newLatch(event);
                this.threadWorkQueue.addFront(latch);
            } else {
                Object latch = epStatementHandle.getInsertIntoBackLatchFactory().newLatch(event);
                this.threadWorkQueue.addBack(latch);
            }
        } else if (addToFront) {
            this.threadWorkQueue.addFront(event);
        } else {
            this.threadWorkQueue.addBack(event);
        }
    }

    @Override
    public void setInternalEventRouter(InternalEventRouter internalEventRouter) {
        throw new UnsupportedOperationException("Isolated runtime does not route itself");
    }

    @Override
    public Long getNextScheduledTime() {
        return this.services.getSchedulingService().getNearestTimeHandle();
    }

    @Override
    public Map<String, Long> getStatementNearestSchedules() {
        return EPRuntimeImpl.getStatementNearestSchedulesInternal(this.services.getSchedulingService(), this.unisolatedServices.getStatementLifecycleSvc());
    }
}

