/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.core.service.ExpressionResultCacheStackEntry;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class ExpressionResultCacheService {
    private HashMap<String, SoftReference<ExpressionResultCacheEntry<EventBean, Collection<EventBean>>>> collPropertyCache;
    private IdentityHashMap<Object, SoftReference<ExpressionResultCacheEntry<EventBean[], Object>>> exprDeclCacheObject;
    private IdentityHashMap<Object, SoftReference<ExpressionResultCacheEntry<EventBean[], Collection<EventBean>>>> exprDeclCacheCollection;
    private IdentityHashMap<Object, SoftReference<ExpressionResultCacheEntry<Long[], Object>>> enumMethodCache;
    private Deque<ExpressionResultCacheStackEntry> callStack;
    private Deque<Long> lastValueCacheStack;

    public void pushStack(ExpressionResultCacheStackEntry lambda) {
        if (this.callStack == null) {
            this.callStack = new ArrayDeque<ExpressionResultCacheStackEntry>();
            this.lastValueCacheStack = new ArrayDeque<Long>(10);
        }
        this.callStack.push(lambda);
    }

    public boolean popLambda() {
        this.callStack.remove();
        return this.callStack.isEmpty();
    }

    public Deque<ExpressionResultCacheStackEntry> getStack() {
        return this.callStack;
    }

    public ExpressionResultCacheEntry<EventBean, Collection<EventBean>> getPropertyColl(String propertyNameFullyQualified, EventBean reference) {
        this.initPropertyCollCache();
        SoftReference<ExpressionResultCacheEntry<EventBean, Collection<EventBean>>> ref = this.collPropertyCache.get(propertyNameFullyQualified);
        if (ref == null) {
            return null;
        }
        ExpressionResultCacheEntry<EventBean, Collection<EventBean>> entry = ref.get();
        if (entry == null) {
            return null;
        }
        if (entry.getReference() != reference) {
            return null;
        }
        return entry;
    }

    public void savePropertyColl(String propertyNameFullyQualified, EventBean reference, Collection<EventBean> events) {
        ExpressionResultCacheEntry<EventBean, Collection<EventBean>> entry = new ExpressionResultCacheEntry<EventBean, Collection<EventBean>>(reference, events);
        this.collPropertyCache.put(propertyNameFullyQualified, new SoftReference<ExpressionResultCacheEntry<EventBean, Collection<EventBean>>>(entry));
    }

    public ExpressionResultCacheEntry<EventBean[], Object> getDeclaredExpressionLastValue(Object node, EventBean[] eventsPerStream) {
        this.initExprDeclaredCacheObject();
        SoftReference<ExpressionResultCacheEntry<EventBean[], Object>> ref = this.exprDeclCacheObject.get(node);
        if (ref == null) {
            return null;
        }
        ExpressionResultCacheEntry<EventBean[], Object> entry = ref.get();
        if (entry == null) {
            return null;
        }
        EventBean[] cacheEvents = entry.getReference();
        if (cacheEvents.length != eventsPerStream.length) {
            return null;
        }
        for (int i = 0; i < cacheEvents.length; ++i) {
            if (cacheEvents[i] == eventsPerStream[i]) continue;
            return null;
        }
        return entry;
    }

    public void saveDeclaredExpressionLastValue(Object node, EventBean[] eventsPerStream, Object result) {
        EventBean[] copy = new EventBean[eventsPerStream.length];
        System.arraycopy(eventsPerStream, 0, copy, 0, copy.length);
        ExpressionResultCacheEntry<EventBean[], Object> entry = new ExpressionResultCacheEntry<EventBean[], Object>(copy, result);
        this.exprDeclCacheObject.put(node, new SoftReference<ExpressionResultCacheEntry<EventBean[], Object>>(entry));
    }

    public ExpressionResultCacheEntry<EventBean[], Collection<EventBean>> getDeclaredExpressionLastColl(Object node, EventBean[] eventsPerStream) {
        this.initExprDeclaredCacheCollection();
        SoftReference<ExpressionResultCacheEntry<EventBean[], Collection<EventBean>>> ref = this.exprDeclCacheCollection.get(node);
        if (ref == null) {
            return null;
        }
        ExpressionResultCacheEntry<EventBean[], Collection<EventBean>> entry = ref.get();
        if (entry == null) {
            return null;
        }
        EventBean[] cacheEvents = entry.getReference();
        if (cacheEvents.length != eventsPerStream.length) {
            return null;
        }
        for (int i = 0; i < cacheEvents.length; ++i) {
            if (cacheEvents[i] == eventsPerStream[i]) continue;
            return null;
        }
        return entry;
    }

    public void saveDeclaredExpressionLastColl(Object node, EventBean[] eventsPerStream, Collection<EventBean> result) {
        EventBean[] copy = new EventBean[eventsPerStream.length];
        System.arraycopy(eventsPerStream, 0, copy, 0, copy.length);
        ExpressionResultCacheEntry<EventBean[], Collection<EventBean>> entry = new ExpressionResultCacheEntry<EventBean[], Collection<EventBean>>(copy, result);
        this.exprDeclCacheCollection.put(node, new SoftReference<ExpressionResultCacheEntry<EventBean[], Collection<EventBean>>>(entry));
    }

    public ExpressionResultCacheEntry<Long[], Object> getEnumerationMethodLastValue(Object node) {
        this.initEnumMethodCache();
        SoftReference<ExpressionResultCacheEntry<Long[], Object>> ref = this.enumMethodCache.get(node);
        if (ref == null) {
            return null;
        }
        ExpressionResultCacheEntry<Long[], Object> entry = ref.get();
        if (entry == null) {
            return null;
        }
        Long[] required = entry.getReference();
        if (required.length != this.lastValueCacheStack.size()) {
            return null;
        }
        Iterator<Long> prov = this.lastValueCacheStack.iterator();
        for (int i = 0; i < this.lastValueCacheStack.size(); ++i) {
            if (required[i].equals(prov.next())) continue;
            return null;
        }
        return entry;
    }

    public void saveEnumerationMethodLastValue(Object node, Object result) {
        Long[] snapshot = this.lastValueCacheStack.toArray(new Long[this.lastValueCacheStack.size()]);
        ExpressionResultCacheEntry<Long[], Object> entry = new ExpressionResultCacheEntry<Long[], Object>(snapshot, result);
        this.enumMethodCache.put(node, new SoftReference<ExpressionResultCacheEntry<Long[], Object>>(entry));
    }

    private void initEnumMethodCache() {
        if (this.enumMethodCache == null) {
            this.enumMethodCache = new IdentityHashMap();
        }
    }

    private void initPropertyCollCache() {
        if (this.collPropertyCache == null) {
            this.collPropertyCache = new HashMap();
        }
    }

    private void initExprDeclaredCacheObject() {
        if (this.exprDeclCacheObject == null) {
            this.exprDeclCacheObject = new IdentityHashMap();
        }
    }

    private void initExprDeclaredCacheCollection() {
        if (this.exprDeclCacheCollection == null) {
            this.exprDeclCacheCollection = new IdentityHashMap();
        }
    }

    public void pushContext(long contextNumber) {
        this.lastValueCacheStack.push(contextNumber);
    }

    public void popContext() {
        this.lastValueCacheStack.remove();
    }
}

