/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.DeliveryConvertor;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultDeliveryStrategyImpl
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyImpl.class);
    private final String statementName;
    private final Object subscriber;
    private final FastMethod updateFastMethod;
    private final FastMethod startFastMethod;
    private final FastMethod endFastMethod;
    private final FastMethod updateRStreamFastMethod;
    private final DeliveryConvertor deliveryConvertor;

    public ResultDeliveryStrategyImpl(String statementName, Object subscriber, DeliveryConvertor deliveryConvertor, Method method, Method startMethod, Method endMethod, Method rStreamMethod) {
        this.statementName = statementName;
        this.subscriber = subscriber;
        this.deliveryConvertor = deliveryConvertor;
        FastClass fastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.updateFastMethod = fastClass.getMethod(method);
        this.startFastMethod = startMethod != null ? fastClass.getMethod(startMethod) : null;
        this.endFastMethod = endMethod != null ? fastClass.getMethod(endMethod) : null;
        this.updateRStreamFastMethod = rStreamMethod != null ? fastClass.getMethod(rStreamMethod) : null;
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[] params;
        NaturalEventBean natural;
        EventBean event;
        if (this.startFastMethod != null) {
            int countNew = 0;
            int countOld = 0;
            if (result != null) {
                countNew = this.count(result.getFirst());
                countOld = this.count(result.getSecond());
            }
            Object[] params2 = new Object[]{countNew, countOld};
            try {
                this.startFastMethod.invoke(this.subscriber, params2);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statementName, log, e, params2, this.subscriber, this.startFastMethod);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.startFastMethod);
            }
        }
        EventBean[] newData = null;
        EventBean[] oldData = null;
        if (result != null) {
            newData = result.getFirst();
            oldData = result.getSecond();
        }
        if (newData != null && newData.length > 0) {
            for (int i = 0; i < newData.length; ++i) {
                event = newData[i];
                if (!(event instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)event;
                params = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateFastMethod.invoke(this.subscriber, params);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statementName, log, e, params, this.subscriber, this.updateFastMethod);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, params, this.subscriber, this.updateFastMethod);
                }
            }
        }
        if (this.updateRStreamFastMethod != null && oldData != null && oldData.length > 0) {
            for (int i = 0; i < oldData.length; ++i) {
                event = oldData[i];
                if (!(event instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)event;
                params = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateRStreamFastMethod.invoke(this.subscriber, params);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statementName, log, e, params, this.subscriber, this.updateRStreamFastMethod);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, params, this.subscriber, this.updateRStreamFastMethod);
                }
            }
        }
        if (this.endFastMethod != null) {
            try {
                this.endFastMethod.invoke(this.subscriber, null);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statementName, log, e, null, this.subscriber, this.endFastMethod);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.endFastMethod);
            }
        }
    }

    protected static void handle(String statementName, Log logger, InvocationTargetException e, Object[] params, Object subscriber, FastMethod method) {
        String message = JavaClassHelper.getMessageInvocationTarget(statementName, method.getJavaMethod(), subscriber.getClass().getName(), params, e);
        logger.error((Object)message, e.getTargetException());
    }

    protected static void handleThrowable(Log logger, Throwable t, Object[] params, Object subscriber, FastMethod method) {
        String message = "Unexpected exception when invoking method '" + method.getName() + "' on subscriber class '" + subscriber.getClass().getSimpleName() + "' for parameters " + (params == null ? "null" : Arrays.toString(params)) + " : " + t.getClass().getSimpleName() + " : " + t.getMessage();
        logger.error((Object)message, t);
    }

    private int count(EventBean[] events) {
        if (events == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < events.length; ++i) {
            EventBean event = events[i];
            if (!(event instanceof NaturalEventBean)) continue;
            ++count;
        }
        return count;
    }
}

