/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyImpl;
import com.espertech.esper.event.NaturalEventBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultDeliveryStrategyObjectArr
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyImpl.class);
    private final String statementName;
    private final Object subscriber;
    private final FastMethod fastMethod;

    public ResultDeliveryStrategyObjectArr(String statementName, Object subscriber, Method method) {
        this.statementName = statementName;
        this.subscriber = subscriber;
        FastClass fastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.fastMethod = fastClass.getMethod(method);
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[][] oldData;
        Object[][] newData;
        if (result == null) {
            newData = null;
            oldData = null;
        } else {
            newData = this.convert(result.getFirst());
            oldData = this.convert(result.getSecond());
        }
        Object[] params = new Object[]{newData, oldData};
        try {
            this.fastMethod.invoke(this.subscriber, params);
        }
        catch (InvocationTargetException e) {
            ResultDeliveryStrategyImpl.handle(this.statementName, log, e, params, this.subscriber, this.fastMethod);
        }
    }

    private Object[][] convert(EventBean[] events) {
        if (events == null || events.length == 0) {
            return null;
        }
        Object[][] result = new Object[events.length][];
        int length = 0;
        for (int i = 0; i < result.length; ++i) {
            if (!(events[i] instanceof NaturalEventBean)) continue;
            NaturalEventBean natural = (NaturalEventBean)events[i];
            result[length] = natural.getNatural();
            ++length;
        }
        if (length == 0) {
            return null;
        }
        if (length != events.length) {
            Object[][] reduced = new Object[length][];
            System.arraycopy(result, 0, reduced, 0, length);
            result = reduced;
        }
        return result;
    }
}

