/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.client.annotation.Drop;
import com.espertech.esper.client.annotation.Priority;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.ExpressionResultCacheService;
import com.espertech.esper.core.service.SchedulingServiceAudit;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementContextFactory;
import com.espertech.esper.core.service.StatementResultServiceImpl;
import com.espertech.esper.epl.core.MethodResolutionServiceImpl;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.spec.CreateWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.epl.spec.PluggableObjectRegistryImpl;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.pattern.PatternContextFactoryDefault;
import com.espertech.esper.pattern.PatternObjectHelper;
import com.espertech.esper.pattern.PatternObjectResolutionServiceImpl;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolStmtHandler;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolStmtSvc;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.view.StatementStopServiceImpl;
import com.espertech.esper.view.ViewEnumHelper;
import com.espertech.esper.view.ViewResolutionServiceImpl;
import java.lang.annotation.Annotation;
import java.util.Map;

public class StatementContextFactoryDefault
implements StatementContextFactory {
    private final PluggableObjectRegistryImpl viewRegistry;
    private final PluggableObjectCollection patternObjectClasses;
    private final Class systemVirtualDWViewFactory;

    public StatementContextFactoryDefault(PluggableObjectCollection viewPlugIns, PluggableObjectCollection plugInPatternObj, Class systemVirtualDWViewFactory) {
        this.viewRegistry = new PluggableObjectRegistryImpl(new PluggableObjectCollection[]{ViewEnumHelper.getBuiltinViews(), viewPlugIns});
        this.systemVirtualDWViewFactory = systemVirtualDWViewFactory;
        this.patternObjectClasses = new PluggableObjectCollection();
        this.patternObjectClasses.addObjects(plugInPatternObj);
        this.patternObjectClasses.addObjects(PatternObjectHelper.getBuiltinPatternObjects());
    }

    @Override
    public StatementContext makeContext(String statementId, String statementName, String expression, boolean hasVariables, EPServicesContext engineServices, Map<String, Object> optAdditionalContext, OnTriggerDesc optOnTriggerDesc, CreateWindowDesc optCreateWindowDesc, boolean isFireAndForget, Annotation[] annotations, EPIsolationUnitServices isolationUnitServices, String optionalCreateNamedWindowName, String optionalContextName) {
        Audit scheduleAudit;
        StatementAgentInstanceLock defaultStatementAgentInstanceLock;
        ScheduleBucket scheduleBucket = engineServices.getSchedulingMgmtService().allocateBucket();
        if (optOnTriggerDesc != null && optOnTriggerDesc instanceof OnTriggerWindowDesc) {
            String windowName = ((OnTriggerWindowDesc)optOnTriggerDesc).getWindowName();
            defaultStatementAgentInstanceLock = engineServices.getNamedWindowService().getNamedWindowLock(windowName);
            if (defaultStatementAgentInstanceLock == null) {
                throw new EPStatementException("Named window '" + windowName + "' has not been declared", expression);
            }
        } else if (optCreateWindowDesc != null) {
            defaultStatementAgentInstanceLock = engineServices.getNamedWindowService().getNamedWindowLock(optCreateWindowDesc.getWindowName());
            if (defaultStatementAgentInstanceLock == null) {
                defaultStatementAgentInstanceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression, annotations);
                engineServices.getNamedWindowService().addNamedWindowLock(optCreateWindowDesc.getWindowName(), defaultStatementAgentInstanceLock, statementName);
            }
        } else {
            defaultStatementAgentInstanceLock = engineServices.getStatementLockFactory().getStatementLock(statementName, expression, annotations);
        }
        StatementMetricHandle stmtMetric = null;
        if (!isFireAndForget) {
            stmtMetric = engineServices.getMetricsReportingService().getStatementHandle(statementId, statementName);
        }
        AnnotationAnalysisResult annotationData = AnnotationAnalysisResult.analyzeAnnotations(annotations);
        EPStatementHandle epStatementHandle = new EPStatementHandle(statementId, statementName, expression, expression, hasVariables, stmtMetric, annotationData.getPriority(), annotationData.isPremptive());
        MethodResolutionServiceImpl methodResolutionService = new MethodResolutionServiceImpl(engineServices.getEngineImportService(), engineServices.getSchedulingService());
        PatternContextFactoryDefault patternContextFactory = new PatternContextFactoryDefault();
        ViewResolutionServiceImpl viewResolutionService = new ViewResolutionServiceImpl(this.viewRegistry, optionalCreateNamedWindowName, this.systemVirtualDWViewFactory);
        PatternObjectResolutionServiceImpl patternResolutionService = new PatternObjectResolutionServiceImpl(this.patternObjectClasses);
        SchedulingServiceSPI schedulingService = engineServices.getSchedulingService();
        FilterServiceSPI filterService = engineServices.getFilterService();
        if (isolationUnitServices != null) {
            filterService = isolationUnitServices.getFilterService();
            schedulingService = isolationUnitServices.getSchedulingService();
        }
        if ((scheduleAudit = AuditEnum.SCHEDULE.getAudit(annotations)) != null) {
            schedulingService = new SchedulingServiceAudit(statementName, schedulingService);
        }
        StatementAIResourceRegistry statementAgentInstanceRegistry = null;
        ContextDescriptor contextDescriptor = null;
        if (optionalContextName != null && (contextDescriptor = engineServices.getContextManagementService().getContextDescriptor(optionalContextName)) != null) {
            statementAgentInstanceRegistry = contextDescriptor.getAiResourceRegistryFactory().make();
        }
        boolean countSubexpressions = engineServices.getConfigSnapshot().getEngineDefaults().getPatterns().getMaxSubexpressions() != null;
        PatternSubexpressionPoolStmtSvc patternSubexpressionPoolStmtSvc = null;
        if (countSubexpressions) {
            PatternSubexpressionPoolStmtHandler stmtCounter = new PatternSubexpressionPoolStmtHandler();
            patternSubexpressionPoolStmtSvc = new PatternSubexpressionPoolStmtSvc(engineServices.getPatternSubexpressionPoolSvc(), stmtCounter);
            engineServices.getPatternSubexpressionPoolSvc().addPatternContext(statementName, stmtCounter);
        }
        return new StatementContext(engineServices.getEngineURI(), engineServices.getEngineInstanceId(), statementId, null, statementName, expression, schedulingService, scheduleBucket, engineServices.getEventAdapterService(), epStatementHandle, viewResolutionService, patternResolutionService, null, new StatementStopServiceImpl(), methodResolutionService, patternContextFactory, filterService, engineServices.getNamedWindowService(), engineServices.getVariableService(), new StatementResultServiceImpl(statementName, engineServices.getStatementLifecycleSvc(), engineServices.getMetricsReportingService(), engineServices.getThreadingService()), engineServices.getEngineSettingsService().getPlugInEventTypeResolutionURIs(), engineServices.getValueAddEventService(), engineServices.getConfigSnapshot(), engineServices.getInternalEventEngineRouteDest(), engineServices.getMetricsReportingService(), engineServices.getViewService(), annotations, engineServices.getExceptionHandlingService(), new ExpressionResultCacheService(), engineServices.getEventTypeIdGenerator(), statementAgentInstanceRegistry, defaultStatementAgentInstanceLock, contextDescriptor, patternSubexpressionPoolStmtSvc);
    }

    public static class AnnotationAnalysisResult {
        private int priority;
        private boolean isPremptive;

        private AnnotationAnalysisResult(int priority, boolean premptive) {
            this.priority = priority;
            this.isPremptive = premptive;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isPremptive() {
            return this.isPremptive;
        }

        public static AnnotationAnalysisResult analyzeAnnotations(Annotation[] annotations) {
            boolean preemptive = false;
            int priority = 0;
            boolean hasPrioritySetting = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Priority) {
                    priority = ((Priority)annotation).value();
                    hasPrioritySetting = true;
                }
                if (!(annotation instanceof Drop)) continue;
                preemptive = true;
            }
            if (!hasPrioritySetting && preemptive) {
                priority = 1;
            }
            return new AnnotationAnalysisResult(priority, preemptive);
        }
    }
}

