/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatementStateListener;
import com.espertech.esper.core.service.StatementLifecycleEvent;
import com.espertech.esper.core.service.StatementLifecycleObserver;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementEventDispatcherUnthreaded
implements StatementLifecycleObserver {
    private static Log log = LogFactory.getLog(StatementEventDispatcherUnthreaded.class);
    private final EPServiceProvider serviceProvider;
    private final Iterable<EPStatementStateListener> statementListeners;

    public StatementEventDispatcherUnthreaded(EPServiceProvider serviceProvider, Iterable<EPStatementStateListener> statementListeners) {
        this.serviceProvider = serviceProvider;
        this.statementListeners = statementListeners;
    }

    @Override
    public void observe(StatementLifecycleEvent event) {
        block7: {
            block6: {
                if (event.getEventType() != StatementLifecycleEvent.LifecycleEventType.CREATE) break block6;
                Iterator<EPStatementStateListener> it = this.statementListeners.iterator();
                while (it.hasNext()) {
                    try {
                        it.next().onStatementCreate(this.serviceProvider, event.getStatement());
                    }
                    catch (RuntimeException ex) {
                        log.error((Object)("Caught runtime exception in onStatementCreate callback:" + ex.getMessage()), (Throwable)ex);
                    }
                }
                break block7;
            }
            if (event.getEventType() != StatementLifecycleEvent.LifecycleEventType.STATECHANGE) break block7;
            Iterator<EPStatementStateListener> it = this.statementListeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().onStatementStateChange(this.serviceProvider, event.getStatement());
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Caught runtime exception in onStatementCreate callback:" + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }
}

