/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.util.ManagedReadWriteLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementEventTypeRefImpl
implements StatementEventTypeRef {
    private static final Log log = LogFactory.getLog(StatementEventTypeRefImpl.class);
    private final ManagedReadWriteLock mapLock;
    private final HashMap<String, Set<String>> typeToStmt = new HashMap();
    private final HashMap<String, Set<String>> stmtToType = new HashMap();

    public StatementEventTypeRefImpl() {
        this.mapLock = new ManagedReadWriteLock("StatementEventTypeRefImpl", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferences(String statementName, Set<String> eventTypesReferenced) {
        if (eventTypesReferenced.isEmpty()) {
            return;
        }
        this.mapLock.acquireWriteLock();
        try {
            for (String ref : eventTypesReferenced) {
                this.addReference(statementName, ref);
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferencesStatement(String statementName) {
        this.mapLock.acquireWriteLock();
        try {
            Set<String> types = this.stmtToType.remove(statementName);
            if (types != null) {
                for (String type : types) {
                    this.removeReference(statementName, type);
                }
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferencesType(String name) {
        this.mapLock.acquireWriteLock();
        try {
            Set<String> statementNames = this.typeToStmt.remove(name);
            if (statementNames != null) {
                for (String statementName : statementNames) {
                    this.removeReference(statementName, name);
                }
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUse(String eventTypeName) {
        this.mapLock.acquireReadLock();
        try {
            boolean bl = this.typeToStmt.containsKey(eventTypeName);
            return bl;
        }
        finally {
            this.mapLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStatementNamesForType(String eventTypeName) {
        this.mapLock.acquireReadLock();
        try {
            Set<String> types = this.typeToStmt.get(eventTypeName);
            if (types == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(types);
            return set;
        }
        finally {
            this.mapLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTypesForStatementName(String statementName) {
        this.mapLock.acquireReadLock();
        try {
            Set<String> types = this.stmtToType.get(statementName);
            if (types == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(types);
            return set;
        }
        finally {
            this.mapLock.releaseReadLock();
        }
    }

    private void addReference(String statementName, String eventTypeName) {
        Set<String> statements = this.typeToStmt.get(eventTypeName);
        if (statements == null) {
            statements = new HashSet<String>();
            this.typeToStmt.put(eventTypeName, statements);
        }
        statements.add(statementName);
        Set<String> types = this.stmtToType.get(statementName);
        if (types == null) {
            types = new HashSet<String>();
            this.stmtToType.put(statementName, types);
        }
        types.add(eventTypeName);
    }

    private void removeReference(String statementName, String eventTypeName) {
        Set<String> types;
        Set<String> statements = this.typeToStmt.get(eventTypeName);
        if (statements != null) {
            if (!statements.remove(statementName)) {
                log.info((Object)("Failed to find statement name '" + statementName + "' in collection"));
            }
            if (statements.isEmpty()) {
                this.typeToStmt.remove(eventTypeName);
            }
        }
        if ((types = this.stmtToType.get(statementName)) != null) {
            if (!types.remove(eventTypeName)) {
                log.info((Object)("Failed to find event type '" + eventTypeName + "' in collection"));
            }
            if (types.isEmpty()) {
                this.stmtToType.remove(statementName);
            }
        }
    }

    protected HashMap<String, Set<String>> getTypeToStmt() {
        return this.typeToStmt;
    }

    protected HashMap<String, Set<String>> getStmtToType() {
        return this.stmtToType;
    }
}

