/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.core.service.EPStatementListenerSet;
import com.espertech.esper.core.service.EPStatementSPI;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyFactory;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementResultListener;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.core.thread.OutboundUnitRunnable;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.MetricReportingServiceSPI;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatementResultServiceImpl
implements StatementResultService {
    private static Log log = LogFactory.getLog(StatementResultServiceImpl.class);
    private final String statementName;
    private final StatementLifecycleSvc statementLifecycleSvc;
    private final MetricReportingService metricReportingService;
    private final ThreadingService threadingService;
    private EPStatementSPI epStatement;
    private EPServiceProviderSPI epServiceProvider;
    private boolean isInsertInto;
    private boolean isPattern;
    private boolean isDistinct;
    private boolean isForClause;
    private StatementMetricHandle statementMetricHandle;
    private boolean forClauseDelivery = false;
    private ExprEvaluator[] groupDeliveryExpressions;
    private ExprEvaluatorContext exprEvaluatorContext;
    private Class[] selectClauseTypes;
    private String[] selectClauseColumnNames;
    private EPStatementListenerSet statementListenerSet;
    private boolean isMakeNatural;
    private boolean isMakeSynthetic;
    private ResultDeliveryStrategy statementResultNaturalStrategy;
    private EventBean lastIterableEvent;
    private Set<StatementResultListener> statementOutputHooks;
    protected ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>> lastResults = new ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>>(){

        @Override
        protected synchronized ArrayDeque<UniformPair<EventBean[]>> initialValue() {
            return new ArrayDeque<UniformPair<EventBean[]>>();
        }
    };

    public StatementResultServiceImpl(String statementName, StatementLifecycleSvc statementLifecycleSvc, MetricReportingServiceSPI metricReportingService, ThreadingService threadingService) {
        log.debug((Object)".ctor");
        this.statementName = statementName;
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.metricReportingService = metricReportingService;
        this.statementOutputHooks = metricReportingService != null ? metricReportingService.getStatementOutputHooks() : Collections.EMPTY_SET;
        this.threadingService = threadingService;
    }

    @Override
    public void setContext(EPStatementSPI epStatement, EPServiceProviderSPI epServiceProvider, boolean isInsertInto, boolean isPattern, boolean isDistinct, boolean isForClause, StatementMetricHandle statementMetricHandle) {
        this.epStatement = epStatement;
        this.epServiceProvider = epServiceProvider;
        this.isInsertInto = isInsertInto;
        this.isPattern = isPattern;
        this.isDistinct = isDistinct;
        this.isForClause = isForClause;
        this.isMakeSynthetic = isInsertInto || isPattern || isDistinct || isForClause;
        this.statementMetricHandle = statementMetricHandle;
    }

    @Override
    public void setSelectClause(Class[] selectClauseTypes, String[] selectClauseColumnNames, boolean forClauseDelivery, ExprEvaluator[] groupDeliveryExpressions, ExprEvaluatorContext exprEvaluatorContext) {
        if (selectClauseTypes == null || selectClauseTypes.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause expression types");
        }
        if (selectClauseColumnNames == null || selectClauseColumnNames.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause column names");
        }
        this.selectClauseTypes = selectClauseTypes;
        this.selectClauseColumnNames = selectClauseColumnNames;
        this.forClauseDelivery = forClauseDelivery;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.groupDeliveryExpressions = groupDeliveryExpressions;
    }

    @Override
    public boolean isMakeSynthetic() {
        return this.isMakeSynthetic;
    }

    @Override
    public boolean isMakeNatural() {
        return this.isMakeNatural;
    }

    @Override
    public EventBean getLastIterableEvent() {
        return this.lastIterableEvent;
    }

    @Override
    public void setUpdateListeners(EPStatementListenerSet statementListenerSet) {
        if (this.epStatement != null) {
            this.statementLifecycleSvc.updatedListeners(this.epStatement, statementListenerSet);
        }
        this.statementListenerSet = statementListenerSet;
        this.isMakeNatural = statementListenerSet.getSubscriber() != null;
        boolean bl = this.isMakeSynthetic = !statementListenerSet.getListeners().isEmpty() || !statementListenerSet.getStmtAwareListeners().isEmpty() || this.isPattern || this.isInsertInto || this.isDistinct | this.isForClause;
        if (statementListenerSet.getSubscriber() == null) {
            this.statementResultNaturalStrategy = null;
            this.isMakeNatural = false;
            return;
        }
        this.statementResultNaturalStrategy = ResultDeliveryStrategyFactory.create(this.statementName, statementListenerSet.getSubscriber(), this.selectClauseTypes, this.selectClauseColumnNames);
        this.isMakeNatural = true;
    }

    @Override
    public void indicate(UniformPair<EventBean[]> results) {
        if (results != null) {
            if (MetricReportingPath.isMetricsEnabled && this.statementMetricHandle.isEnabled()) {
                int numIStream = results.getFirst() != null ? results.getFirst().length : 0;
                int numRStream = results.getSecond() != null ? results.getSecond().length : 0;
                this.metricReportingService.accountOutput(this.statementMetricHandle, numIStream, numRStream);
            }
            if (results.getFirst() != null && results.getFirst().length != 0) {
                this.lastResults.get().add(results);
                this.lastIterableEvent = results.getFirst()[0];
            } else if (results.getSecond() != null && results.getSecond().length != 0) {
                this.lastResults.get().add(results);
            }
        }
    }

    @Override
    public void execute() {
        ArrayDeque<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        UniformPair<EventBean[]> events = EventBeanUtility.flattenList(dispatches);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".execute", events);
        }
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isOutboundThreading()) {
            this.threadingService.submitOutbound(new OutboundUnitRunnable(events, this));
        } else {
            this.processDispatch(events);
        }
        dispatches.clear();
    }

    public void processDispatch(UniformPair<EventBean[]> events) {
        Map<MultiKeyUntyped, UniformPair<EventBean[]>> groups;
        if (!this.forClauseDelivery) {
            this.dispatchInternal(events);
            return;
        }
        if (this.groupDeliveryExpressions == null || this.groupDeliveryExpressions.length == 0) {
            UniformPair<Object> todeliver = new UniformPair<Object>(null, null);
            if (events.getFirst() != null) {
                for (EventBean event : events.getFirst()) {
                    todeliver.setFirst(new EventBean[]{event});
                    this.dispatchInternal(todeliver);
                }
            }
            todeliver.setFirst(null);
            if (events.getSecond() != null) {
                for (EventBean event : events.getSecond()) {
                    todeliver.setSecond(new EventBean[]{event});
                    this.dispatchInternal(todeliver);
                }
            }
            return;
        }
        try {
            groups = this.getGroupedResults(events);
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unexpected exception evaluating grouped-delivery expressions: " + ex.getMessage() + ", delivering ungrouped"), (Throwable)ex);
            this.dispatchInternal(events);
            return;
        }
        for (Map.Entry<MultiKeyUntyped, UniformPair<EventBean[]>> group : groups.entrySet()) {
            this.dispatchInternal(group.getValue());
        }
    }

    private Map<MultiKeyUntyped, UniformPair<EventBean[]>> getGroupedResults(UniformPair<EventBean[]> events) {
        if (events == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<MultiKeyUntyped, UniformPair<EventBean[]>> groups = new LinkedHashMap<MultiKeyUntyped, UniformPair<EventBean[]>>();
        EventBean[] eventsPerStream = new EventBean[1];
        this.getGroupedResults(groups, events.getFirst(), true, eventsPerStream);
        this.getGroupedResults(groups, events.getSecond(), false, eventsPerStream);
        return groups;
    }

    private void getGroupedResults(Map<MultiKeyUntyped, UniformPair<EventBean[]>> groups, EventBean[] events, boolean insertStream, EventBean[] eventsPerStream) {
        if (events == null) {
            return;
        }
        for (EventBean event : events) {
            EventBean evalEvent = event;
            if (evalEvent instanceof NaturalEventBean) {
                evalEvent = ((NaturalEventBean)evalEvent).getOptionalSynthetic();
            }
            Object[] keys = new Object[this.groupDeliveryExpressions.length];
            for (int i = 0; i < this.groupDeliveryExpressions.length; ++i) {
                eventsPerStream[0] = evalEvent;
                keys[i] = this.groupDeliveryExpressions[i].evaluate(eventsPerStream, true, this.exprEvaluatorContext);
            }
            MultiKeyUntyped key = new MultiKeyUntyped(keys);
            UniformPair<Object> groupEntry = groups.get(key);
            if (groupEntry == null) {
                groupEntry = insertStream ? new UniformPair<Object>(new EventBean[]{event}, null) : new UniformPair<EventBean[]>(null, new EventBean[]{event});
                groups.put(key, groupEntry);
                continue;
            }
            if (insertStream) {
                if (groupEntry.getFirst() == null) {
                    groupEntry.setFirst(new EventBean[]{event});
                    continue;
                }
                groupEntry.setFirst(EventBeanUtility.addToArray(groupEntry.getFirst(), event));
                continue;
            }
            if (groupEntry.getSecond() == null) {
                groupEntry.setSecond(new EventBean[]{event});
                continue;
            }
            groupEntry.setSecond(EventBeanUtility.addToArray(groupEntry.getSecond(), event));
        }
    }

    private void dispatchInternal(UniformPair<EventBean[]> events) {
        String message;
        if (this.statementResultNaturalStrategy != null) {
            this.statementResultNaturalStrategy.execute(events);
        }
        EventBean[] newEventArr = events != null ? events.getFirst() : null;
        EventBean[] oldEventArr = events != null ? events.getSecond() : null;
        for (UpdateListener updateListener : this.statementListenerSet.listeners) {
            try {
                updateListener.update(newEventArr, oldEventArr);
            }
            catch (Throwable t) {
                message = "Unexpected exception invoking listener update method on listener class '" + updateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                log.error((Object)message, t);
            }
        }
        if (!this.statementListenerSet.stmtAwareListeners.isEmpty()) {
            for (StatementAwareUpdateListener statementAwareUpdateListener : this.statementListenerSet.getStmtAwareListeners()) {
                try {
                    statementAwareUpdateListener.update(newEventArr, oldEventArr, this.epStatement, this.epServiceProvider);
                }
                catch (Throwable t) {
                    message = "Unexpected exception invoking listener update method on listener class '" + statementAwareUpdateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error((Object)message, t);
                }
            }
        }
        if (AuditPath.isAuditEnabled && !this.statementOutputHooks.isEmpty()) {
            for (StatementResultListener statementResultListener : this.statementOutputHooks) {
                statementResultListener.update(newEventArr, oldEventArr, this.epStatement.getName(), this.epStatement, this.epServiceProvider);
            }
        }
    }

    @Override
    public void dispatchOnStop() {
        this.lastIterableEvent = null;
        ArrayDeque<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        if (dispatches.isEmpty()) {
            return;
        }
        this.execute();
        this.lastResults = new ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>>(){

            @Override
            protected synchronized ArrayDeque<UniformPair<EventBean[]>> initialValue() {
                return new ArrayDeque<UniformPair<EventBean[]>>();
            }
        };
    }
}

