/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.soda;

import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.ContainedEventSelect;
import com.espertech.esper.client.soda.ContextDescriptor;
import com.espertech.esper.client.soda.ContextDescriptorCategory;
import com.espertech.esper.client.soda.ContextDescriptorCategoryItem;
import com.espertech.esper.client.soda.ContextDescriptorInitiatedTerminated;
import com.espertech.esper.client.soda.ContextDescriptorKeyedSegmented;
import com.espertech.esper.client.soda.ContextDescriptorKeyedSegmentedItem;
import com.espertech.esper.client.soda.ContextDescriptorTemporalCrontabSingle;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionDeclaration;
import com.espertech.esper.client.soda.Filter;
import com.espertech.esper.client.soda.FilterStream;
import com.espertech.esper.client.soda.ForClauseItem;
import com.espertech.esper.client.soda.MatchRecognizeDefine;
import com.espertech.esper.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.client.soda.MethodInvocationStream;
import com.espertech.esper.client.soda.OnInsertSplitStreamClause;
import com.espertech.esper.client.soda.OnInsertSplitStreamItem;
import com.espertech.esper.client.soda.OnMergeClause;
import com.espertech.esper.client.soda.OnMergeMatchItem;
import com.espertech.esper.client.soda.OnMergeMatchedAction;
import com.espertech.esper.client.soda.OnMergeMatchedDeleteAction;
import com.espertech.esper.client.soda.OnMergeMatchedInsertAction;
import com.espertech.esper.client.soda.OnMergeMatchedUpdateAction;
import com.espertech.esper.client.soda.OnSetClause;
import com.espertech.esper.client.soda.OnUpdateClause;
import com.espertech.esper.client.soda.OrderByElement;
import com.espertech.esper.client.soda.OuterJoinQualifier;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternFilterExpr;
import com.espertech.esper.client.soda.PatternStream;
import com.espertech.esper.client.soda.ProjectedStream;
import com.espertech.esper.client.soda.PropertyValueExpressionPair;
import com.espertech.esper.client.soda.SelectClauseElement;
import com.espertech.esper.client.soda.SelectClauseExpression;
import com.espertech.esper.client.soda.Stream;
import com.espertech.esper.client.soda.View;
import com.espertech.esper.core.soda.SODAAnalyzerPatternCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SODAAnalyzer {
    /*
     * WARNING - void declaration
     */
    public static List<Expression> analyzeModelExpressions(EPStatementObjectModel model) {
        Expression expr;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (model.getExpressionDeclarations() != null) {
            for (ExpressionDeclaration decl : model.getExpressionDeclarations()) {
                expressions.add(decl.getExpression());
            }
        }
        if (model.getCreateContext() != null) {
            ContextDescriptor desc = model.getCreateContext().getDescriptor();
            if (desc instanceof ContextDescriptorKeyedSegmented) {
                ContextDescriptorKeyedSegmented ks = (ContextDescriptorKeyedSegmented)desc;
                for (ContextDescriptorKeyedSegmentedItem contextDescriptorKeyedSegmentedItem : ks.getItems()) {
                    if (contextDescriptorKeyedSegmentedItem.getFilter().getFilter() == null) continue;
                    expressions.add(contextDescriptorKeyedSegmentedItem.getFilter().getFilter());
                }
            }
            if (desc instanceof ContextDescriptorCategory) {
                ContextDescriptorCategory cat = (ContextDescriptorCategory)desc;
                for (ContextDescriptorCategoryItem contextDescriptorCategoryItem : cat.getItems()) {
                    if (contextDescriptorCategoryItem.getExpression() == null) continue;
                    expressions.add(contextDescriptorCategoryItem.getExpression());
                }
                if (cat.getFilter().getFilter() != null) {
                    expressions.add(cat.getFilter().getFilter());
                }
            }
            if (desc instanceof ContextDescriptorInitiatedTerminated) {
                ContextDescriptorInitiatedTerminated init = (ContextDescriptorInitiatedTerminated)desc;
                if (init.getInitiatedFilter() != null) {
                    if (init.getInitiatedFilter().getFilter() != null) {
                        expressions.add(init.getInitiatedFilter().getFilter());
                    }
                } else {
                    SODAAnalyzer.collectPatternExpressions(expressions, init.getInitiatedPattern());
                }
                if (init.getTerminatedTimePeriod() != null) {
                    expressions.add(init.getTerminatedTimePeriod());
                }
            }
            if (desc instanceof ContextDescriptorTemporalCrontabSingle) {
                ContextDescriptorTemporalCrontabSingle ts = (ContextDescriptorTemporalCrontabSingle)desc;
                for (Expression expression : ts.getCrontabStartExpressions()) {
                    expressions.add(expression);
                }
                for (Expression expression : ts.getCrontabEndExpressions()) {
                    expressions.add(expression);
                }
            }
        }
        if (model.getCreateVariable() != null && (expr = model.getCreateVariable().getOptionalAssignment()) != null) {
            expressions.add(expr);
        }
        if (model.getCreateWindow() != null) {
            expr = model.getCreateWindow().getInsertWhereClause();
            if (expr != null) {
                expressions.add(expr);
            }
            for (View view : model.getCreateWindow().getViews()) {
                expressions.addAll(view.getParameters());
            }
        }
        if (model.getUpdateClause() != null) {
            if (model.getUpdateClause().getOptionalWhereClause() != null) {
                expressions.add(model.getUpdateClause().getOptionalWhereClause());
            }
            if (model.getUpdateClause().getAssignments() != null) {
                for (AssignmentPair pair : model.getUpdateClause().getAssignments()) {
                    expressions.add(pair.getValue());
                }
            }
        }
        if (model.getOnExpr() != null) {
            OnUpdateClause onUpdate;
            OnSetClause onSet;
            if (model.getOnExpr() instanceof OnInsertSplitStreamClause) {
                OnInsertSplitStreamClause onSplit = (OnInsertSplitStreamClause)model.getOnExpr();
                for (OnInsertSplitStreamItem onInsertSplitStreamItem : onSplit.getItems()) {
                    if (onInsertSplitStreamItem.getSelectClause() != null) {
                        for (SelectClauseElement selement : onInsertSplitStreamItem.getSelectClause().getSelectList()) {
                            if (!(selement instanceof SelectClauseExpression)) continue;
                            SelectClauseExpression sexpr = (SelectClauseExpression)selement;
                            expressions.add(sexpr.getExpression());
                        }
                    }
                    if (onInsertSplitStreamItem.getWhereClause() == null) continue;
                    expressions.add(onInsertSplitStreamItem.getWhereClause());
                }
            }
            if (model.getOnExpr() instanceof OnSetClause && (onSet = (OnSetClause)model.getOnExpr()).getAssignments() != null) {
                for (AssignmentPair assignmentPair : onSet.getAssignments()) {
                    expressions.add(assignmentPair.getValue());
                }
            }
            if (model.getOnExpr() instanceof OnUpdateClause && (onUpdate = (OnUpdateClause)model.getOnExpr()).getAssignments() != null) {
                for (AssignmentPair assignmentPair : onUpdate.getAssignments()) {
                    expressions.add(assignmentPair.getValue());
                }
            }
            if (model.getOnExpr() instanceof OnMergeClause) {
                OnMergeClause onMerge = (OnMergeClause)model.getOnExpr();
                for (OnMergeMatchItem onMergeMatchItem : onMerge.getMatchItems()) {
                    if (onMergeMatchItem.getOptionalCondition() != null) {
                        expressions.add(onMergeMatchItem.getOptionalCondition());
                    }
                    for (OnMergeMatchedAction action : onMergeMatchItem.getActions()) {
                        if (action instanceof OnMergeMatchedDeleteAction) {
                            OnMergeMatchedDeleteAction delete = (OnMergeMatchedDeleteAction)action;
                            if (delete.getWhereClause() == null) continue;
                            expressions.add(delete.getWhereClause());
                            continue;
                        }
                        if (action instanceof OnMergeMatchedUpdateAction) {
                            OnMergeMatchedUpdateAction update = (OnMergeMatchedUpdateAction)action;
                            if (update.getWhereClause() != null) {
                                expressions.add(update.getWhereClause());
                            }
                            for (AssignmentPair assignment : update.getAssignments()) {
                                expressions.add(assignment.getValue());
                            }
                            continue;
                        }
                        if (!(action instanceof OnMergeMatchedInsertAction)) continue;
                        OnMergeMatchedInsertAction insert = (OnMergeMatchedInsertAction)action;
                        if (insert.getWhereClause() != null) {
                            expressions.add(insert.getWhereClause());
                        }
                        for (SelectClauseElement element : insert.getSelectList()) {
                            if (!(element instanceof SelectClauseExpression)) continue;
                            SelectClauseExpression expr2 = (SelectClauseExpression)element;
                            expressions.add(expr2.getExpression());
                        }
                    }
                }
            }
        }
        if (model.getSelectClause() != null && model.getSelectClause().getSelectList() != null) {
            for (SelectClauseElement selectItem : model.getSelectClause().getSelectList()) {
                if (!(selectItem instanceof SelectClauseExpression)) continue;
                SelectClauseExpression selectClauseExpression = (SelectClauseExpression)selectItem;
                expressions.add(selectClauseExpression.getExpression());
            }
        }
        if (model.getFromClause() != null) {
            for (Stream stream : model.getFromClause().getStreams()) {
                ProjectedStream projectedStream;
                MethodInvocationStream methodInvocationStream;
                if (stream instanceof FilterStream) {
                    FilterStream filterStream = (FilterStream)stream;
                    Filter filter = filterStream.getFilter();
                    if (filter != null && filter.getFilter() != null) {
                        expressions.add(filterStream.getFilter().getFilter());
                    }
                    if (filter != null && filter.getOptionalPropertySelects() != null) {
                        for (ContainedEventSelect contained : filter.getOptionalPropertySelects()) {
                            for (SelectClauseElement selectItem : contained.getSelectClause().getSelectList()) {
                                if (!(selectItem instanceof SelectClauseExpression)) continue;
                                SelectClauseExpression selectExpr = (SelectClauseExpression)selectItem;
                                expressions.add(selectExpr.getExpression());
                            }
                            if (contained.getWhereClause() == null) continue;
                            expressions.add(contained.getWhereClause());
                        }
                    }
                }
                if (stream instanceof PatternStream) {
                    PatternStream patternStream = (PatternStream)stream;
                    SODAAnalyzer.collectPatternExpressions(expressions, patternStream.getExpression());
                }
                if (stream instanceof MethodInvocationStream && (methodInvocationStream = (MethodInvocationStream)stream).getParameterExpressions() != null) {
                    expressions.addAll(methodInvocationStream.getParameterExpressions());
                }
                if (!(stream instanceof ProjectedStream) || (projectedStream = (ProjectedStream)stream).getViews() == null) continue;
                for (View view : projectedStream.getViews()) {
                    expressions.addAll(view.getParameters());
                }
            }
            if (model.getFromClause().getOuterJoinQualifiers() != null) {
                for (OuterJoinQualifier q : model.getFromClause().getOuterJoinQualifiers()) {
                    expressions.add(q.getLeft());
                    expressions.add(q.getRight());
                    for (PropertyValueExpressionPair propertyValueExpressionPair : q.getAdditionalProperties()) {
                        expressions.add(propertyValueExpressionPair.getLeft());
                        expressions.add(propertyValueExpressionPair.getRight());
                    }
                }
            }
        }
        if (model.getWhereClause() != null) {
            expressions.add(model.getWhereClause());
        }
        if (model.getGroupByClause() != null) {
            for (Expression groupByExpr : model.getGroupByClause().getGroupByExpressions()) {
                expressions.add(groupByExpr);
            }
        }
        if (model.getHavingClause() != null) {
            expressions.add(model.getHavingClause());
        }
        if (model.getOutputLimitClause() != null) {
            if (model.getOutputLimitClause().getWhenExpression() != null) {
                expressions.add(model.getOutputLimitClause().getWhenExpression());
            }
            if (model.getOutputLimitClause().getThenAssignments() != null) {
                for (AssignmentPair thenAssign : model.getOutputLimitClause().getThenAssignments()) {
                    expressions.add(thenAssign.getValue());
                }
            }
            if (model.getOutputLimitClause().getCrontabAtParameters() != null) {
                void var4_36;
                Expression[] arr$ = model.getOutputLimitClause().getCrontabAtParameters();
                int len$ = arr$.length;
                boolean bl = false;
                while (var4_36 < len$) {
                    Expression expression = arr$[var4_36];
                    expressions.add(expression);
                    ++var4_36;
                }
            }
            if (model.getOutputLimitClause().getTimePeriodExpression() != null) {
                expressions.add(model.getOutputLimitClause().getTimePeriodExpression());
            }
            if (model.getOutputLimitClause().getAfterTimePeriodExpression() != null) {
                expressions.add(model.getOutputLimitClause().getAfterTimePeriodExpression());
            }
        }
        if (model.getOrderByClause() != null) {
            for (OrderByElement orderByElement : model.getOrderByClause().getOrderByExpressions()) {
                expressions.add(orderByElement.getExpression());
            }
        }
        if (model.getMatchRecognizeClause() != null) {
            if (model.getMatchRecognizeClause().getPartitionExpressions() != null) {
                for (Expression partitionExpr : model.getMatchRecognizeClause().getPartitionExpressions()) {
                    expressions.add(partitionExpr);
                }
            }
            for (SelectClauseExpression selectItemMR : model.getMatchRecognizeClause().getMeasures()) {
                if (!(selectItemMR instanceof SelectClauseExpression)) continue;
                SelectClauseExpression selectClauseExpression = selectItemMR;
                expressions.add(selectClauseExpression.getExpression());
            }
            for (MatchRecognizeDefine define : model.getMatchRecognizeClause().getDefines()) {
                expressions.add(define.getExpression());
            }
            if (model.getMatchRecognizeClause().getIntervalClause() != null && model.getMatchRecognizeClause().getIntervalClause().getExpression() != null) {
                expressions.add(model.getMatchRecognizeClause().getIntervalClause().getExpression());
            }
        }
        if (model.getForClause() != null) {
            for (ForClauseItem item : model.getForClause().getItems()) {
                if (item.getExpressions() == null) continue;
                expressions.addAll(item.getExpressions());
            }
        }
        return expressions;
    }

    private static void collectPatternExpressions(final List<Expression> expressions, PatternExpr expression) {
        SODAAnalyzerPatternCollector collector = new SODAAnalyzerPatternCollector(){

            @Override
            public void visit(PatternExpr patternExpr) {
                PatternFilterExpr filter;
                if (patternExpr instanceof PatternFilterExpr && (filter = (PatternFilterExpr)patternExpr).getFilter().getFilter() != null) {
                    expressions.add(filter.getFilter().getFilter());
                }
            }
        };
        SODAAnalyzer.traversePatternRecursive(expression, collector);
    }

    private static void traversePatternRecursive(PatternExpr patternExpr, SODAAnalyzerPatternCollector collectorFunction) {
        collectorFunction.visit(patternExpr);
        if (patternExpr == null) {
            return;
        }
        if (patternExpr.getChildren() == null) {
            return;
        }
        for (PatternExpr child : patternExpr.getChildren()) {
            SODAAnalyzer.traversePatternRecursive(child, collectorFunction);
        }
    }

    public static List<MatchRecognizeRegEx> analyzeModelMatchRecogRegexs(EPStatementObjectModel model) {
        if (model.getMatchRecognizeClause() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(model.getMatchRecognizeClause().getPattern());
    }

    public static List<PatternExpr> analyzeModelPatterns(EPStatementObjectModel model) {
        ContextDescriptorInitiatedTerminated cat;
        ContextDescriptor desc;
        ArrayList<PatternExpr> result = new ArrayList<PatternExpr>();
        if (model.getFromClause() != null) {
            for (Stream stream : model.getFromClause().getStreams()) {
                PatternStream patternStream;
                if (!(stream instanceof PatternStream) || (patternStream = (PatternStream)stream).getExpression() == null) continue;
                result.add(patternStream.getExpression());
            }
        }
        if (model.getCreateContext() != null && (desc = model.getCreateContext().getDescriptor()) instanceof ContextDescriptorInitiatedTerminated && (cat = (ContextDescriptorInitiatedTerminated)desc).getInitiatedPattern() != null) {
            result.add(cat.getInitiatedPattern());
        }
        return result;
    }
}

