/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.JoinSetFilter;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPPreparedExecuteMethod {
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    private static final Log log = LogFactory.getLog(EPPreparedExecuteMethod.class);
    private final StatementSpecCompiled statementSpec;
    private final ResultSetProcessor resultSetProcessor;
    private final NamedWindowProcessor[] processors;
    private final JoinSetComposer joinComposer;
    private final JoinSetFilter joinFilter;
    private final AgentInstanceContext agentInstanceContext;
    private EventBeanReader eventBeanReader;
    private final FilterSpecCompiled[] filters;

    public EPPreparedExecuteMethod(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            queryPlanLog.info((Object)("Query plans for Fire-and-forget query '" + statementContext.getExpression() + "'"));
        }
        this.statementSpec = statementSpec;
        this.validateExecuteQuery();
        int numStreams = statementSpec.getStreamSpecs().size();
        EventType[] typesPerStream = new EventType[numStreams];
        String[] namesPerStream = new String[numStreams];
        this.processors = new NamedWindowProcessor[numStreams];
        StreamJoinAnalysisResult streamJoinAnalysisResult = new StreamJoinAnalysisResult(numStreams);
        Arrays.fill(streamJoinAnalysisResult.getNamedWindow(), true);
        this.agentInstanceContext = new AgentInstanceContext(statementContext, null, null, null, null);
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs().get(i);
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            String streamName = namedSpec.getWindowName();
            if (namedSpec.getOptionalStreamName() != null) {
                streamName = namedSpec.getOptionalStreamName();
            }
            namesPerStream[i] = streamName;
            this.processors[i] = services.getNamedWindowService().getProcessor(namedSpec.getWindowName());
            if (this.processors[i] == null) {
                throw new ExprValidationException("A named window by name '" + namedSpec.getWindowName() + "' does not exist");
            }
            NamedWindowProcessorInstance processorInstance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
            typesPerStream[i] = this.processors[i].getTailView().getEventType();
            if (!this.processors[i].isVirtualDataWindow()) continue;
            streamJoinAnalysisResult.getViewExternal()[i] = processorInstance.getRootViewInstance().getVirtualDataWindow();
        }
        this.filters = new FilterSpecCompiled[numStreams];
        if (statementSpec.getFilterRootNode() != null) {
            LinkedHashMap<String, Pair<EventType, String>> tagged = new LinkedHashMap<String, Pair<EventType, String>>();
            for (int i = 0; i < numStreams; ++i) {
                try {
                    StreamTypeServiceImpl types = new StreamTypeServiceImpl(typesPerStream, namesPerStream, new boolean[numStreams], services.getEngineURI(), false);
                    this.filters[i] = FilterSpecCompiler.makeFilterSpec(typesPerStream[i], namesPerStream[i], Collections.singletonList(statementSpec.getFilterRootNode()), null, tagged, tagged, types, statementContext.getMethodResolutionService(), statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getEventAdapterService(), services.getEngineURI(), null, statementContext, Collections.singleton(i), null, statementContext.getConfigSnapshot());
                    continue;
                }
                catch (Exception ex) {
                    log.warn((Object)("Unexpected exception analyzing filter paths: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        boolean[] isIStreamOnly = new boolean[namesPerStream.length];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(typesPerStream, namesPerStream, isIStreamOnly, services.getEngineURI(), true);
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, null);
        ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(statementSpec, this.agentInstanceContext, typeService, null, new boolean[0], true, ContextPropertyRegistryImpl.EMPTY_REGISTRY);
        this.resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(this.agentInstanceContext, resultSetProcessorPrototype);
        if (statementSpec.getSelectClauseSpec().isDistinct()) {
            if (this.resultSetProcessor.getResultEventType() instanceof EventTypeSPI) {
                this.eventBeanReader = ((EventTypeSPI)this.resultSetProcessor.getResultEventType()).getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(this.resultSetProcessor.getResultEventType());
            }
        }
        if (numStreams > 1) {
            Viewable[] viewablePerStream = new Viewable[numStreams];
            for (int i = 0; i < numStreams; ++i) {
                viewablePerStream[i] = this.processors[i].getProcessorInstance(this.agentInstanceContext).getTailViewInstance();
            }
            JoinSetComposerPrototype joinSetComposerPrototype = JoinSetComposerPrototypeFactory.makeComposerPrototype(null, null, statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typesPerStream, namesPerStream, streamJoinAnalysisResult, queryPlanLogging, null, new HistoricalViewableDesc(numStreams), this.agentInstanceContext);
            JoinSetComposerDesc joinSetComposerDesc = joinSetComposerPrototype.create(viewablePerStream);
            this.joinComposer = joinSetComposerDesc.getJoinSetComposer();
            this.joinFilter = joinSetComposerDesc.getPostJoinFilterEvaluator() != null ? new JoinSetFilter(joinSetComposerDesc.getPostJoinFilterEvaluator()) : null;
        } else {
            this.joinComposer = null;
            this.joinFilter = null;
        }
    }

    public EventType getEventType() {
        return this.resultSetProcessor.getResultEventType();
    }

    public EPPreparedQueryResult execute() {
        int numStreams = this.processors.length;
        Collection[] snapshots = new Collection[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(i);
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            NamedWindowProcessorInstance processorInstance = this.processors[i].getProcessorInstance(this.agentInstanceContext);
            if (processorInstance == null) {
                throw new EPException("Named window '" + namedSpec.getWindowName() + "' is associated to context '" + this.processors[i].getContextName() + "' that is not available for querying");
            }
            snapshots[i] = processorInstance.getTailViewInstance().snapshot(this.filters[i], this.statementSpec.getAnnotations());
            if (namedSpec.getFilterExpressions().size() == 0) continue;
            snapshots[i] = this.getFiltered(snapshots[i], namedSpec.getFilterExpressions());
        }
        this.resultSetProcessor.clear();
        return this.process(snapshots);
    }

    public EPPreparedQueryResult process(Collection<EventBean>[] snapshots) {
        UniformPair<EventBean[]> results;
        int numStreams = this.processors.length;
        if (numStreams == 1) {
            if (this.statementSpec.getFilterRootNode() != null) {
                snapshots[0] = this.getFiltered(snapshots[0], Arrays.asList(this.statementSpec.getFilterRootNode()));
            }
            EventBean[] rows = snapshots[0].toArray(new EventBean[snapshots[0].size()]);
            results = this.resultSetProcessor.processViewResult(rows, null, true);
        } else {
            EventBean[][] oldDataPerStream = new EventBean[numStreams][];
            EventBean[][] newDataPerStream = new EventBean[numStreams][];
            for (int i = 0; i < numStreams; ++i) {
                newDataPerStream[i] = snapshots[i].toArray(new EventBean[snapshots[i].size()]);
            }
            UniformPair<Set<MultiKey<EventBean>>> result = this.joinComposer.join(newDataPerStream, oldDataPerStream, this.agentInstanceContext);
            if (this.joinFilter != null) {
                this.joinFilter.process(result.getFirst(), null, this.agentInstanceContext);
            }
            results = this.resultSetProcessor.processJoinResult(result.getFirst(), null, true);
        }
        if (this.statementSpec.getSelectClauseSpec().isDistinct()) {
            results.setFirst(EventBeanUtility.getDistinctByProp(results.getFirst(), this.eventBeanReader));
        }
        return new EPPreparedQueryResult(this.resultSetProcessor.getResultEventType(), results.getFirst());
    }

    private void validateExecuteQuery() throws ExprValidationException {
        if (this.statementSpec.getSubSelectExpressions().size() > 0) {
            throw new ExprValidationException("Subqueries are not a supported feature of on-demand queries");
        }
        for (int i = 0; i < this.statementSpec.getStreamSpecs().size(); ++i) {
            if (!(this.statementSpec.getStreamSpecs().get(i) instanceof NamedWindowConsumerStreamSpec)) {
                throw new ExprValidationException("On-demand queries require named windows and do not allow event streams or patterns");
            }
            if (this.statementSpec.getStreamSpecs().get(i).getViewSpecs().size() == 0) continue;
            throw new ExprValidationException("Views are not a supported feature of on-demand queries");
        }
        if (this.statementSpec.getOutputLimitSpec() != null) {
            throw new ExprValidationException("Output rate limiting is not a supported feature of on-demand queries");
        }
        if (this.statementSpec.getInsertIntoDesc() != null) {
            throw new ExprValidationException("Insert-into is not a supported feature of on-demand queries");
        }
    }

    private List<EventBean> getFiltered(Collection<EventBean> snapshot, List<ExprNode> filterExpressions) {
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> filteredSnapshot = new ArrayList<EventBean>();
        ExprEvaluator[] evaluators = ExprNodeUtility.getEvaluators(filterExpressions);
        for (EventBean row : snapshot) {
            boolean pass = true;
            eventsPerStream[0] = row;
            for (ExprEvaluator filter : evaluators) {
                Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, this.agentInstanceContext);
                if (result == null || result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            filteredSnapshot.add(row);
        }
        return filteredSnapshot;
    }

    public FilterSpecCompiled[] getFilters() {
        return this.filters;
    }

    public NamedWindowProcessor[] getProcessors() {
        return this.processors;
    }
}

