/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethod;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.view.ViewProcessingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EPStatementStartMethodBase
implements EPStatementStartMethod {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodBase.class);
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    protected final StatementSpecCompiled statementSpec;
    protected final EPServicesContext services;
    protected final StatementContext statementContext;
    protected final boolean queryPlanLogging;

    protected EPStatementStartMethodBase(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        this.statementSpec = statementSpec;
        this.services = services;
        this.statementContext = statementContext;
        this.queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
    }

    public abstract EPStatementStartResult startInternal(boolean var1, boolean var2, boolean var3) throws ExprValidationException, ViewProcessingException;

    @Override
    public EPStatementStartResult start(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        this.statementContext.getVariableService().setLocalVersion();
        boolean queryPlanLogging = this.services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging && queryPlanLog.isInfoEnabled()) {
            queryPlanLog.info((Object)("Query plans for statement '" + this.statementContext.getStatementName() + "' expression '" + this.statementContext.getExpression() + "'"));
        }
        if (this.statementSpec.getOptionalContextName() != null && this.statementContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context by name '" + this.statementSpec.getOptionalContextName() + "' has not been declared");
        }
        return this.startInternal(isNewStatement, isRecoveringStatement, isRecoveringResilient);
    }

    protected EPStatementAgentInstanceHandle getDefaultAgentInstanceHandle() {
        return new EPStatementAgentInstanceHandle(this.statementContext.getEpStatementHandle(), this.statementContext.getDefaultAgentInstanceLock(), null, new StatementAgentInstanceFilterVersion());
    }

    protected AgentInstanceContext getDefaultAgentInstanceContext() {
        EPStatementAgentInstanceHandle handle = this.getDefaultAgentInstanceHandle();
        return new AgentInstanceContext(this.statementContext, handle, null, null, null);
    }
}

